//=============================================================================
// VisuStella MZ - Victory Aftermath
// VisuMZ_3_VictoryAftermath.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_3_VictoryAftermath = true;

var VisuMZ = VisuMZ || {};
VisuMZ.VictoryAftermath = VisuMZ.VictoryAftermath || {};
VisuMZ.VictoryAftermath.version = 1.13;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 3] [Version 1.13] [VictoryAftermath]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/Victory_Aftermath_VisuStella_MZ
 * @base VisuMZ_1_BattleCore
 * @orderAfter VisuMZ_1_BattleCore
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 *
 * The Victory Aftermath plugin consolidates the rewards granted upon finishing
 * a battle successfully into one screen (or more if there are level ups).
 * This helps reduce the amount of button presses needed to display similar
 * information by default. The level up screens will also display parameter
 * changes and new skills acquired in addition to victory quotes.
 *
 * Features include all (but not limited to) the following:
 * 
 * * Consolidates EXP, Gold, and Items acquired through battle rewards into one
 *   battle screen.
 * * EXP gauges for currently active battle party will be displayed on the same
 *   screen to indicate progress.
 * * Upon leveling up, individual screens can be shown (optionally) to display
 *   parameter changes, new skills acquired, and level up quotes.
 * * Plugin Commands can be used to clear/add new quotes at any time.
 * * Plugin Commands can be used by bypass certain parts of the Victory
 *   Aftermath segments or the entire thing completely.
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Required Plugin List ------
 *
 * - VisuMZ_1_BattleCore
 *
 * This plugin requires the above listed plugins to be installed inside your
 * game's Plugin Manager list in order to work. You cannot start your game with
 * this plugin enabled without the listed plugins.
 *
 * ------ Tier 3 ------
 *
 * This plugin is a Tier 3 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 *
 * ============================================================================
 * Extra Features
 * ============================================================================
 *
 * There are some extra features found if other VisuStella MZ plugins are found
 * present in the Plugin Manager list.
 *
 * ---
 *
 * VisuMZ_0_CoreEngine
 *
 * - The EXP gauge colors will match the color settings found in the Core
 * Engine's Plugin Parameters instead of defaulting to specific colors.
 *
 * - The continue message will display any changed input keys designated by
 * the Core Engine's Plugin Parameters.
 *
 * ---
 *
 * VisuMZ_1_MainMenuCore
 *
 * - Upon leveling up, the Menu Image will show up (optional) as a bust during
 * the quote segment.
 *
 * ---
 *
 * ============================================================================
 * Notetags
 * ============================================================================
 *
 * The following are notetags that have been added through this plugin. These
 * notetags will not work with your game if this plugin is OFF or not present.
 *
 * ---
 *
 * <Level Up Quotes>
 *  text
 *  text
 *  text
 *  text
 *  <New Quote>
 *  text
 *  text
 *  text
 *  text
 *  <New Quote>
 *  text
 *  text
 *  text
 *  text
 * </Level Up Quotes>
 *
 * - Used for: Actor Notetags
 * - Description
 * - Replace 'text' with the text you'd want the actor to say when leveling up.
 * - The <New Quote> tag is used between the <Level Up Quotes> notetags to
 *   separate quotes.
 * - If an actor has multiple quotes (due to the <New Quote> notetag), then a
 *   random quote will be selected upon level up.
 * - If this notetag is not found inside an actor's notebox, a random level up
 *   quote will be selected from the Plugin Parameters => Level Up => Quotes =>
 *   Level Up Quotes plugin parameter.
 *
 * ---
 *
 * <New Skill Quotes>
 *  text
 *  text
 *  text
 *  text
 *  <New Quote>
 *  text
 *  text
 *  text
 *  text
 *  <New Quote>
 *  text
 *  text
 *  text
 *  text
 * </New Skill Quotes>
 *
 * - Used for: Actor Notetags
 * - Description
 * - Replace 'text' with the text you'd want the actor to say when leveling up
 *   in addition to learning a new skill upon leveling up.
 * - The <New Quote> tag is used between the <New Skill Quotes> notetags to
 *   separate quotes.
 * - If an actor has multiple quotes (due to the <New Quote> notetag), then a
 *   random quote will be selected upon level up and learning a new skill.
 * - If this notetag is not found inside an actor's notebox, a random new skill
 *   quote will be selected from the Plugin Parameters => Level Up => Quotes =>
 *   New Skill Quotes plugin parameter.
 *
 * ============================================================================
 * Plugin Commands
 * ============================================================================
 *
 * The following are Plugin Commands that come with this plugin. They can be
 * accessed through the Plugin Command event command.
 *
 * ---
 * 
 * === Actor Plugin Commands ===
 * 
 * ---
 *
 * Actor: Add Level Up Quotes
 * - Add new entries target actor's level up quotes.
 *
 *   Actor ID:
 *   - Select ID of target actor to add quotes for.
 *
 *   New Quotes:
 *   - Add new entries to actor's level up quotes.
 *   - Text codes allowed. %1 - Actor's Name
 *
 * ---
 *
 * Actor: Add New Skill Quotes
 * - Add new entries target actor's new skill quotes.
 *
 *   Actor ID:
 *   - Select ID of target actor to add quotes for.
 *
 *   New Quotes:
 *   - Add new entries to actor's new skill quotes.
 *   - Text codes allowed. %1 - Actor's Name
 *
 * ---
 *
 * Actor: Clear Level Up Quotes
 * - Clear target actor's level up quotes.
 *
 *   Actor ID:
 *   - Select ID of target actor to clear quotes for.
 *
 * ---
 *
 * Actor: Clear New Skill Quotes
 * - Clear target actor's new skill quotes.
 *
 *   Actor ID:
 *   - Select ID of target actor to clear quotes for.
 *
 * ---
 * 
 * === System Plugin Commands ===
 * 
 * ---
 *
 * System: Bypass Victory Motion
 * - Bypass actors performing their victory motion?
 *
 *   Bypass?:
 *   - Bypass actors performing their victory motion?
 *
 * ---
 *
 * System: Bypass Victory Music
 * - Bypass playing the victory music?
 *
 *   Bypass?:
 *   - Bypass playing the victory music?
 *
 * ---
 *
 * System: Bypass Victory Phase
 * - Bypass the entire victory phase and all aspects about it?
 *
 *   Bypass?:
 *   - Bypass the entire victory phase and all aspects about it?
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: General Settings
 * ============================================================================
 *
 * The general settings Plugin Parameters control the overall settings found
 * within the main aspects of the Victory Aftermath sequence.
 *
 * ---
 *
 * General Settings
 * 
 *   Fade In Speed:
 *   - Fade in speed for the victory window.
 * 
 *   Hide Delay (MS):
 *   - Delay in milliseconds before hiding the UI Windows.
 * 
 *   Show Delay (MS):
 *   - Delay in milliseconds before showing the Victory Windows.
 * 
 *   Update Duration:
 *   - Duration in frames on updating actor EXP gauges.
 * 
 *   Auto Skip Auto Battle?:
 *   - Skip the Victory Aftermath sequence if the player has decided to use
 *     the party Auto Battle command?
 * 
 *   Mirror Contents?:
 *   - Mirror the positions of EXP, Gold, and Items?
 * 
 *   Show EXP Gauges?:
 *   - Show the EXP Gauges of the main party members for the first screen of
 *     the Victory Aftermath?
 *   - This is added for those with large parties and cannot fit everything
 *     into one screen for all party members and would prefer not showing any
 *     EXP Gauges at all instead.
 *
 * ---
 * 
 * Collapse Effect
 * 
 *   Normal Collapse Wait?:
 *   - Wait for the normal collapse effect to finish?
 * 
 *   Boss Collapse Wait?:
 *   - Wait for the boss collapse effect to finish?
 * 
 * ---
 * 
 * Victory Music
 * 
 *   Victory BGM:
 *   - Background music to play during the victory sequence.
 * 
 *   Volume:
 *   - Volume of the sound effect played.
 * 
 *   Pitch:
 *   - Pitch of the sound effect played.
 * 
 *   Pan:
 *   - Pan of the sound effect played.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Reward Strips Settings
 * ============================================================================
 *
 * Reward strip settings that appear in the first screen of the Victory
 * Aftermath. These are used to let you have control over what rewards are
 * displayed at the end of each battle and can be used to display custom data
 * from other plugins as well.
 *
 * ---
 *
 * Reward Strip
 * 
 *   Label:
 *   - This one doesn't have any use other than being a label to  quickly
 *     determine what this one is for.
 * 
 *   JS: Show:
 *   - Code used to determine if the reward strip is shown.
 * 
 *   JS: Text:
 *   - Code used to determine if the text displayed as the category.
 * 
 *   JS: Data:
 *   - Code used to determine what data should be displayed in the
 *     reward strip.
 *
 * ---
 * 
 * The default parameters for this will be updated from time to time as more
 * VisuStella MZ plugins are released to add in extra displayed resources that
 * the party can gain from battle.
 *
 * ============================================================================
 * Plugin Parameters: Level Up Settings
 * ============================================================================
 *
 * When actors level up, extra screens will be displayed in the Victory
 * Aftermath sequence. Alter these settings to best fit your game.
 *
 * ---
 *
 * General
 * 
 *   Enable?:
 *   - Enable the Level Up portion of the Victory Aftermath phase?
 * 
 *   Show Face?:
 *   - Show the actor's face?
 * 
 *   Show Param Change?:
 *   - Show an extra column for parameter value differences?
 * 
 *     Hide Level?:
 *     - Hide the level change in the parameter value differences?
 * 
 *   Shown Max Skills:
 *   - The maximum amount of skills that are displayed.
 *   - This is due to limited screen space.
 * 
 *   Show Back Rectangles?:
 *   - Show back rectangles of darker colors to display information better?
 * 
 *     Back Rectangle Color:
 *     - Use #rrggbb for custom colors or regular numbers for text colors
 *       from the Window Skin.
 *
 * ---
 *
 * Quotes
 * 
 *   Level Up Quotes:
 *   - A list of generic level up quotes for those who don't have the
 *     <Level Up Quote> notetags.
 *   - %1 - Actor Name
 * 
 *   New Skill Quotes:
 *   - A list of generic level up quotes for those who don't have the
 *     <New Skill Quote> notetags.
 *   - %1 - Actor Name
 *
 * ---
 *
 * VisuMZ_1_MainMenuCore
 * - The following Plugin Parameters require VisuMZ_1_MainMenuCore.
 * 
 *   Show Bust?:
 *   - Show the actor's menu image as a bust?
 * 
 *   Bust Position X:
 *   - Positon to center the actor's menu image bust.
 *   - You may use JavaScript code.
 * 
 *   Bust Position Y:
 *   - Positon to anchor the actor's menu image bust.
 *   - You may use JavaScript code.
 * 
 *   Bust Scale:
 *   - The amount to scale the actor's menu image bust.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Vocabulary Settings
 * ============================================================================
 *
 * There's certain diction used in the Victory Aftermath plugin that's not set
 * anywhere else in the game. Change the settings to make it fit your game.
 *
 * ---
 *
 * Vocabulary
 * 
 *   Continue Format:
 *   - Text format for continue message.
 *   - %1 - OK key, %2 - Cancel key
 * 
 *   OK Button:
 *   - Text used to represent the OK button.
 *   - If VisuMZ_0_CoreEngine is present, ignore this.
 * 
 *   Cancel Button:
 *   - Text used to represent the Cancel button.
 *   - If VisuMZ_0_CoreEngine is present, ignore this.
 * 
 *   Level Format:
 *   - Text format for actor level.
 *   - %1 - Level
 * 
 *   Level Up:
 *   - Text format for reaching a level up.
 * 
 *   Sound Effect:
 *   - Sound effect played when a level up occurs.
 * 
 *     Volume:
 *     - Volume of the sound effect played.
 * 
 *     Pitch:
 *     - Pitch of the sound effect played.
 * 
 *     Pan:
 *     - Pan of the sound effect played.
 * 
 *   Text Color:
 *   - Use #rrggbb for custom colors or regular numbers for text colors
 *     from the Window Skin.
 * 
 *   New Skill Format:
 *   - Text format describing that a new skill has been learned.
 *   - %1 - Actor Name
 * 
 *   Reward Items:
 *   - Text displayed for items rewarded.
 * 
 *   Victory Title:
 *   - Text displayed at the top of the victory screen.
 *
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 * 
 * 7. If this VisuStella MZ plugin is a paid product, all project team members
 * must purchase their own individual copies of the paid product if they are to
 * use it. Usage includes working on related game mechanics, managing related
 * code, and/or using related Plugin Commands and features. Redistribution of
 * the plugin and/or its code to other members of the team is NOT allowed
 * unless they own the plugin itself as that conflicts with Article 4.
 * 
 * 8. Any extensions and/or addendums made to this plugin's Terms of Use can be
 * found on VisuStella.com and must be followed.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 * 
 * Team VisuStella
 * - Yanfly
 * - Arisu
 * - Olivia
 * - Irina
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.13: September 23, 2021
 * * Bug Fixes!
 * ** Values for parameter differences should no longer be hidden or the same
 *    as the previous values. Fix made by Irina.
 * 
 * Version 1.12: August 27, 2021
 * * Bug Fixes!
 * ** X-Parameters and S-Parameters shown in the level up stat changes should
 *    now display the percentage signs properly. Fix made by Olivia.
 * 
 * Version 1.11: July 9, 2021
 * * Compatibility Update
 * ** Added compatibility functionality for future plugins.
 * 
 * Version 1.10: March 12, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Olivia!
 * *** Plugin Parameters > General > Show EXP Gauges?
 * **** Show the EXP Gauges of the main party members for the first screen of
 *      the Victory Aftermath?
 * **** This is added for those with large parties and cannot fit everything
 *      into one screen for all party members and would prefer not showing any
 *      EXP Gauges at all instead.
 * 
 * Version 1.09: January 15, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Arisu!
 * *** Plugin Parameters > Vocab > Level Up > Volume
 * *** Plugin Parameters > Vocab > Level Up > Pitch
 * *** Plugin Parameters > Vocab > Level Up > Pan
 * **** For the people who want more control over the level up sound effect.
 * 
 * Version 1.08: December 11, 2020
 * * Compatibility Update
 * ** Added compatibility functionality for future plugins.
 * * Feature Updates!
 * ** The default Plugin Parameter for "Reward Strips" have been updated to
 *    contain compatibility for a future plugin.
 * 
 * Version 1.07: December 4, 2020
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Plugin Parameter added by Olivia:
 * ** Plugin Parameters > Level Up Settings > Hide Level?
 * *** Hide the level change in the parameter value differences when comparing
 *     the stat changes from the previous level to the next.
 * 
 * Version 1.06: November 29, 2020
 * * Bug Fixed!
 * ** The default reward strips Plugin Parameters data is now updated for the
 *    SP display costs to show the Skill Points data instead of Ability Points
 *    data. Fix made by Arisu.
 * 
 * Version 1.05: November 8, 2020
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New plugin parameter added by Arisu.
 * *** Plugin Parameters > Reward Strips
 * **** Reward strip settings that appear in the first screen of the Victory
 *      Aftermath. These are used to let you have control over what rewards are
 *      displayed at the end of each battle and can be used to display custom
 *      data from other plugins as well.
 * 
 * Version 1.04: October 25, 2020
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New plugin parameter added by Olivia.
 * *** Plugin Parameters > General > Mirror Contents?
 * **** Mirror the positions of EXP, Gold, and Items?
 * 
 * Version 1.03: October 18, 2020
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** BGM pitch plugin parameter is now uncapped.
 * * New Features!
 * ** New plugin parameters added by Yanfly.
 * *** Plugin Parameters > General > Collapse Effect > Normal Collapse Wait?
 * *** Plugin Parameters > General > Collapse Effect > Boss Collapse Wait?
 * **** These settings enable you to decide if you want the Victory Aftermath
 *      to wait until collapse effects are finished before continuing.
 * *** Plugin Parameters > General > Music > Volume
 * *** Plugin Parameters > General > Music > Pitch
 * *** Plugin Parameters > General > Music > Pan
 * **** Adjusts the volume, pitch, and pan of the victory music.
 * 
 * Version 1.02: September 13, 2020
 * * Feature Update!
 * ** Victory Aftermath windows now wait until all boss collapse effects are
 *    done before showing. Update added by Olivia.
 * * New Features!
 * ** New Plugin Parameter under General Settings: Auto Skip Auto Battle?
 * *** Skip the Victory Aftermath sequence if the player has decided to use the
 *     party Auto Battle command?
 * *** Feature added by Olivia
 * 
 * Version 1.01: September 6, 2020
 * * New Features!
 * ** New Plugin Parameters added in Level Up Settings for disabling
 *    the back rectangles and/or changing their colors.
 *
 * Version 1.00: August 26, 2020
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActorQuotesLevelUpAdd
 * @text Actor: Add Level Up Quotes
 * @desc Add new entries target actor's level up quotes.
 *
 * @arg ActorID:num
 * @text Actor ID
 * @type actor
 * @desc Select ID of target actor to add quotes for.
 * @default 1
 *
 * @arg NewQuotes:arrayjson
 * @text New Quotes
 * @type note[]
 * @desc Add new entries to actor's level up quotes.
 * Text codes allowed. %1 - Actor's Name
 * @default ["\"\\\\c[6]%1\\\\c[0]\\n\\\"Text\\\"\""]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActorQuotesNewSkillAdd
 * @text Actor: Add New Skill Quotes
 * @desc Add new entries target actor's new skill quotes.
 *
 * @arg ActorID:num
 * @text Actor ID
 * @type actor
 * @desc Select ID of target actor to add quotes for.
 * @default 1
 *
 * @arg NewQuotes:arrayjson
 * @text New Quotes
 * @type note[]
 * @desc Add new entries to actor's new skill quotes.
 * Text codes allowed. %1 - Actor's Name
 * @default ["\"\\\\c[6]%1\\\\c[0]\\n\\\"Text\\\"\""]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActorQuotesLevelUpClear
 * @text Actor: Clear Level Up Quotes
 * @desc Clear target actor's level up quotes.
 *
 * @arg ActorID:num
 * @text Actor ID
 * @type actor
 * @desc Select ID of target actor to clear quotes for.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActorQuotesNewSkillClear
 * @text Actor: Clear New Skill Quotes
 * @desc Clear target actor's new skill quotes.
 *
 * @arg ActorID:num
 * @text Actor ID
 * @type actor
 * @desc Select ID of target actor to clear quotes for.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command SystemBypassVictoryMotion
 * @text System: Bypass Victory Motion
 * @desc Bypass actors performing their victory motion?
 *
 * @arg Bypass:eval
 * @text Bypass?
 * @type boolean
 * @on Bypass
 * @off Normal
 * @desc Bypass actors performing their victory motion?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command SystemBypassVictoryMusic
 * @text System: Bypass Victory Music
 * @desc Bypass playing the victory music?
 *
 * @arg Bypass:eval
 * @text Bypass?
 * @type boolean
 * @on Bypass
 * @off Normal
 * @desc Bypass playing the victory music?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command SystemBypassVictoryPhase
 * @text System: Bypass Victory Phase
 * @desc Bypass the entire victory phase and all aspects about it?
 *
 * @arg Bypass:eval
 * @text Bypass?
 * @type boolean
 * @on Bypass
 * @off Normal
 * @desc Bypass the entire victory phase and all aspects about it?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param VictoryAftermath
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param General:struct
 * @text General Settings
 * @type struct<General>
 * @desc General settings pertaining to the Victory Aftermath phase.
 * @default {"General":"","FadeInSpeed:num":"8","HideDelayMS:num":"1500","ShowDelayMS:num":"2000","UpdateDuration:num":"180","AutoBattleAutoSkip:eval":"true","MirrorContents:eval":"false","Collapse":"","WaitRegularCollapse:eval":"true","WaitBossCollapse:eval":"true","Music":"","Bgm:str":"Ship3","volume:num":"90","pitch:num":"100","pan:num":"0"}
 *
 * @param Rewards:arraystruct
 * @text Reward Strips
 * @parent General:struct
 * @type struct<Rewards>[]
 * @desc Reward strip settings that appear in the first screen of the Victory Aftermath.
 * @default ["{\"Label\":\"EXP\",\"Show:func\":\"\\\"return true;\\\"\",\"Text:func\":\"\\\"return TextManager.exp;\\\"\",\"Data:func\":\"\\\"return BattleManager._rewards.exp;\\\"\"}","{\"Label\":\"Gold\",\"Show:func\":\"\\\"return true;\\\"\",\"Text:func\":\"\\\"return TextManager.currencyUnit;\\\"\",\"Data:func\":\"\\\"return BattleManager._rewards.gold;\\\"\"}","{\"Label\":\"AP (Skill Learn System)\",\"Show:func\":\"\\\"return Imported.VisuMZ_2_SkillLearnSystem &&\\\\n    VisuMZ.SkillLearnSystem.Settings.AbilityPoints.ShowVictory;\\\"\",\"Text:func\":\"\\\"return TextManager.abilityPointsAbbr;\\\"\",\"Data:func\":\"\\\"return BattleManager._rewards.abilityPoints;\\\"\"}","{\"Label\":\"CP (Class Change System)\",\"Show:func\":\"\\\"return Imported.VisuMZ_2_ClassChangeSystem &&\\\\n    VisuMZ.ClassChangeSystem.Settings.ClassPoints.ShowVictory;\\\"\",\"Text:func\":\"\\\"return TextManager.classPointsAbbr;\\\"\",\"Data:func\":\"\\\"return BattleManager._rewards.classPoints;\\\"\"}","{\"Label\":\"JP (Class Change System)\",\"Show:func\":\"\\\"return Imported.VisuMZ_2_ClassChangeSystem &&\\\\n    VisuMZ.ClassChangeSystem.Settings.JobPoints.ShowVictory;\\\"\",\"Text:func\":\"\\\"return TextManager.jobPointsAbbr;\\\"\",\"Data:func\":\"\\\"return BattleManager._rewards.jobPoints;\\\"\"}","{\"Label\":\"SP (Skill Learn System)\",\"Show:func\":\"\\\"return Imported.VisuMZ_2_SkillLearnSystem &&\\\\n    VisuMZ.SkillLearnSystem.Settings.SkillPoints.ShowVictory;\\\"\",\"Text:func\":\"\\\"return TextManager.skillPointsAbbr;\\\"\",\"Data:func\":\"\\\"return BattleManager._rewards.skillPoints;\\\"\"}"]
 *
 * @param LevelUp:struct
 * @text Level Up Settings
 * @type struct<LevelUp>
 * @desc Settings pertaining to the Level Up portion of the Victory Aftermath phase.
 * @default {"General":"","Enable:eval":"true","ShowFace:eval":"false","ShowParamDiff:eval":"true","HideLevelDiff:eval":"false","MaxSkills:num":"8","DelayBuffer:num":"200","DrawBackRect:eval":"true","BackRectColor:str":"19","Quotes":"","LevelUpQuotes:arrayjson":"[\"\\\"\\\\\\\\c[6]%1\\\\\\\\c[0]\\\\n\\\\\\\"Alright! A level up!\\\\\\\"\\\"\",\"\\\"\\\\\\\\c[6]%1\\\\\\\\c[0]\\\\n\\\\\\\"Yes! I've leveled up!\\\\\\\"\\\"\",\"\\\"\\\\\\\\c[6]%1\\\\\\\\c[0]\\\\n\\\\\\\"Oh? I've leveled up!?\\\\n This is awesome!\\\\\\\"\\\"\",\"\\\"\\\\\\\\c[6]%1\\\\\\\\c[0]\\\\n\\\\\\\"Looks like I've become stronger!\\\\\\\"\\\"\",\"\\\"\\\\\\\\c[6]%1\\\\\\\\c[0]\\\\n\\\\\\\"I feel like I'm getting used to battle.\\\\\\\"\\\"\",\"\\\"\\\\\\\\c[6]%1\\\\\\\\c[0]\\\\n\\\\\\\"The power! I can feel it!\\\\\\\"\\\"\"]","NewSkillQuotes:arrayjson":"[\"\\\"\\\\\\\\c[6]%1\\\\\\\\c[0]\\\\n\\\\\\\"Looks like I've acquired a new skill!\\\\\\\"\\\"\",\"\\\"\\\\\\\\c[6]%1\\\\\\\\c[0]\\\\n\\\\\\\"This new skill should come in handy.\\\\\\\"\\\"\",\"\\\"\\\\\\\\c[6]%1\\\\\\\\c[0]\\\\n\\\\\\\"It seems I've learned something new!\\\\\\\"\\\"\",\"\\\"\\\\\\\\c[6]%1\\\\\\\\c[0]\\\\n\\\\\\\"I've acquired a new power!\\\\\\\"\\\"\",\"\\\"\\\\\\\\c[6]%1\\\\\\\\c[0]\\\\n\\\\\\\"This should be useful for future battles.\\\\\\\"\\\"\",\"\\\"\\\\\\\\c[6]%1\\\\\\\\c[0]\\\\n\\\\\\\"I wonder what this new skill is like?\\\\\\\"\\\"\"]","MainMenuCore":"","ShowBust:eval":"true","BustPosX:str":"Graphics.width * 0.25","BustPosY:str":"Graphics.height","BustScale:num":"1.20"}
 *
 * @param Vocab:struct
 * @text Vocabulary
 * @type struct<Vocab>
 * @desc The vocabulary used for this plugin and related settings.
 * @default {"ContinueFmt:str":"Press %1 or %2 to continue","KeyOK:str":"OK","KeyCancel:str":"Cancel","LvFmt:str":"LV %1","LvUp:str":"LEVEL UP!","LvUpSfx:str":"Up4","LvUpVolume:num":"90","LvUpPitch:num":"100","LvUpPan:num":"0","LvUpColor:str":"17","NewSkill:str":"%1 has learned:","RewardItems:str":"Items Obtained","Victory:str":"Victory!"}
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * General Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~General:
 *
 * @param General
 * 
 * @param FadeInSpeed:num
 * @text Fade In Speed
 * @parent General
 * @desc Fade in speed for the victory window.
 * @default 8
 *
 * @param HideDelayMS:num
 * @text Hide Delay (MS)
 * @parent General
 * @desc Delay in milliseconds before hiding the UI Windows.
 * @default 1500
 *
 * @param ShowDelayMS:num
 * @text Show Delay (MS)
 * @parent General
 * @desc Delay in milliseconds before showing the Victory Windows.
 * @default 2000
 *
 * @param UpdateDuration:num
 * @text Update Duration
 * @parent General
 * @desc Duration in frames on updating actor EXP gauges.
 * @default 180
 *
 * @param AutoBattleAutoSkip:eval
 * @text Skip Auto Battle?
 * @parent General
 * @type boolean
 * @on Skip
 * @off Don't Skip
 * @desc Skip the Victory Aftermath sequence if the player has
 * decided to use the party Auto Battle command?
 * @default true
 *
 * @param MirrorContents:eval
 * @text Mirror Contents?
 * @parent General
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the positions of EXP, Gold, and Items?
 * @default false
 *
 * @param ShowExpGauges:eval
 * @text Show EXP Gauges?
 * @parent General
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show the EXP Gauges of the main party members
 * for the first screen of the Victory Aftermath?
 * @default true
 * 
 * @param Collapse
 * @text Collapse Effect
 *
 * @param WaitRegularCollapse:eval
 * @text Normal Collapse Wait?
 * @parent Collapse
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait for the normal collapse effect to finish?
 * @default true
 *
 * @param WaitBossCollapse:eval
 * @text Boss Collapse Wait?
 * @parent Collapse
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait for the boss collapse effect to finish?
 * @default true
 * 
 * @param Music
 * @text Victory Music
 *
 * @param Bgm:str
 * @text Victory BGM
 * @parent Music
 * @type file
 * @dir audio/bgm/
 * @desc Background music to play during the victory sequence.
 * @default Ship3
 *
 * @param volume:num
 * @text Volume
 * @parent Music
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 90
 *
 * @param pitch:num
 * @text Pitch
 * @parent Music
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 100
 *
 * @param pan:num
 * @text Pan
 * @parent Music
 * @desc Pan of the sound effect played.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * Rewards Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Rewards:
 *
 * @param Label
 * @desc This one doesn't have any use other than being a label to 
 * quickly determine what this one is for.
 * @default Untitled
 *
 * @param Show:func
 * @text JS: Show
 * @type note
 * @desc Code used to determine if the reward strip is shown.
 * @default "return true;"
 *
 * @param Text:func
 * @text JS: Text
 * @type note
 * @desc Code used to determine if the text displayed as the category.
 * @default "return 'Untitled';"
 *
 * @param Data:func
 * @text JS: Data
 * @type note
 * @desc Code used to determine what data should be displayed in the reward strip.
 * @default "return 0;"
 *
 */
/* ----------------------------------------------------------------------------
 * Level Up Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~LevelUp:
 *
 * @param General
 *
 * @param Enable:eval
 * @text Enable?
 * @parent General
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enable the Level Up portion of the Victory Aftermath phase?
 * @default true
 *
 * @param ShowFace:eval
 * @text Show Face?
 * @parent General
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show the actor's face?
 * @default false
 *
 * @param ShowParamDiff:eval
 * @text Show Param Change?
 * @parent General
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show an extra column for parameter value differences?
 * @default true
 *
 * @param HideLevelDiff:eval
 * @text Hide Level?
 * @parent ShowParamDiff:eval
 * @type boolean
 * @on Hide
 * @off Normal
 * @desc Hide the level change in the parameter value differences?
 * @default false
 *
 * @param MaxSkills:num
 * @text Shown Max Skills
 * @parent General
 * @desc The maximum amount of skills that are displayed.
 * This is due to limited screen space.
 * @default 8
 *
 * @param DelayBuffer:num
 * @text Delay Buffer
 * @parent General
 * @type number
 * @desc How many milliseconds to wait in between playing
 * each level up sound effect?
 * @default 200
 *
 * @param DrawBackRect:eval
 * @text Show Back Rectangles?
 * @parent General
 * @type boolean
 * @on Draw
 * @off Don't Draw
 * @desc Show back rectangles of darker colors to display information better?
 * @default true
 *
 * @param BackRectColor:str
 * @text Back Rectangle Color
 * @parent DrawBackRect:eval
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 19
 *
 * @param Quotes
 *
 * @param LevelUpQuotes:arrayjson
 * @text Level Up Quotes
 * @parent Quotes
 * @type note[]
 * @desc A list of generic level up quotes for those who don't
 * have the <Level Up Quote> notetags. %1 - Actor Name
 * @default ["\"\\\\c[6]%1\\\\c[0]\\n\\\"Alright! A level up!\\\"\"","\"\\\\c[6]%1\\\\c[0]\\n\\\"Yes! I've leveled up!\\\"\"","\"\\\\c[6]%1\\\\c[0]\\n\\\"Oh? I've leveled up!?\\n This is awesome!\\\"\"","\"\\\\c[6]%1\\\\c[0]\\n\\\"Looks like I've become stronger!\\\"\"","\"\\\\c[6]%1\\\\c[0]\\n\\\"I feel like I'm getting used to battle.\\\"\"","\"\\\\c[6]%1\\\\c[0]\\n\\\"The power! I can feel it!\\\"\""]
 *
 * @param NewSkillQuotes:arrayjson
 * @text New Skill Quotes
 * @parent Quotes
 * @type note[]
 * @desc A list of generic level up quotes for those who don't
 * have the <New Skill Quote> notetags. %1 - Actor Name
 * @default ["\"\\\\c[6]%1\\\\c[0]\\n\\\"Looks like I've acquired a new skill!\\\"\"","\"\\\\c[6]%1\\\\c[0]\\n\\\"This new skill should come in handy.\\\"\"","\"\\\\c[6]%1\\\\c[0]\\n\\\"It seems I've learned something new!\\\"\"","\"\\\\c[6]%1\\\\c[0]\\n\\\"I've acquired a new power!\\\"\"","\"\\\\c[6]%1\\\\c[0]\\n\\\"This should be useful for future battles.\\\"\"","\"\\\\c[6]%1\\\\c[0]\\n\\\"I wonder what this new skill is like?\\\"\""]
 *
 * @param MainMenuCore
 * @text VisuMZ_1_MainMenuCore
 *
 * @param ShowBust:eval
 * @text Show Bust?
 * @parent MainMenuCore
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show the actor's menu image as a bust?
 * @default true
 *
 * @param BustPosX:str
 * @text Bust Position X
 * @parent MainMenuCore
 * @desc Positon to center the actor's menu image bust.
 * You may use JavaScript code.
 * @default Graphics.width * 0.25
 *
 * @param BustPosY:str
 * @text Bust Position Y
 * @parent MainMenuCore
 * @desc Positon to anchor the actor's menu image bust.
 * You may use JavaScript code.
 * @default Graphics.height
 *
 * @param BustScale:num
 * @text Bust Scale
 * @parent MainMenuCore
 * @desc The amount to scale the actor's menu image bust.
 * @default 1.20
 *
 */
/* ----------------------------------------------------------------------------
 * Vocabulary Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Vocab:
 *
 * @param ContinueFmt:str
 * @text Continue Format
 * @desc Text format for continue message.
 * %1 - OK key, %2 - Cancel key
 * @default Press %1 or %2 to continue
 *
 * @param KeyOK:str
 * @text OK Button
 * @parent ContinueFmt:str
 * @desc Text used to represent the OK button.
 * If VisuMZ_0_CoreEngine is present, ignore this.
 * @default OK
 *
 * @param KeyCancel:str
 * @text Cancel Button
 * @parent ContinueFmt:str
 * @desc Text used to represent the Cancel button.
 * If VisuMZ_0_CoreEngine is present, ignore this.
 * @default Cancel
 *
 * @param LvFmt:str
 * @text Level Format
 * @desc Text format for actor level.
 * %1 - Level
 * @default LV %1
 *
 * @param LvUp:str
 * @text Level Up
 * @desc Text format for reaching a level up.
 * @default LEVEL UP!
 *
 * @param LvUpSfx:str
 * @text Sound Effect
 * @parent LvUp:str
 * @type file
 * @dir audio/se/
 * @desc Sound effect played when a level up occurs.
 * @default Up4
 *
 * @param LvUpVolume:num
 * @text Volume
 * @parent LvUpSfx:str
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 90
 *
 * @param LvUpPitch:num
 * @text Pitch
 * @parent LvUpSfx:str
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 100
 *
 * @param LvUpPan:num
 * @text Pan
 * @parent LvUpSfx:str
 * @desc Pan of the sound effect played.
 * @default 0
 *
 * @param LvUpColor:str
 * @text Text Color
 * @parent LvUp:str
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 17
 *
 * @param NewSkill:str
 * @text New Skill Format
 * @desc Text format describing that a new skill has been learned.
 * %1 - Actor Name
 * @default %1 has learned:
 *
 * @param RewardItems:str
 * @text Reward Items
 * @desc Text displayed for items rewarded.
 * @default Items Obtained
 *
 * @param Victory:str
 * @text Victory Title
 * @desc Text displayed at the top of the victory screen.
 * @default Victory!
 *
 */
//=============================================================================

const _0x209d9c=_0xc460;(function(_0x30de26,_0x25fb1b){const _0x5bfea8=_0xc460,_0x1b4576=_0x30de26();while(!![]){try{const _0x33dbb4=-parseInt(_0x5bfea8(0x24a))/0x1+parseInt(_0x5bfea8(0x1e7))/0x2+-parseInt(_0x5bfea8(0x290))/0x3+parseInt(_0x5bfea8(0x1a0))/0x4*(parseInt(_0x5bfea8(0x29d))/0x5)+parseInt(_0x5bfea8(0x232))/0x6*(-parseInt(_0x5bfea8(0x2af))/0x7)+parseInt(_0x5bfea8(0x197))/0x8*(parseInt(_0x5bfea8(0x1c9))/0x9)+-parseInt(_0x5bfea8(0x154))/0xa;if(_0x33dbb4===_0x25fb1b)break;else _0x1b4576['push'](_0x1b4576['shift']());}catch(_0x451128){_0x1b4576['push'](_0x1b4576['shift']());}}}(_0x47e5,0xb3338));var label=_0x209d9c(0x315),tier=tier||0x0,dependencies=[_0x209d9c(0x176)],pluginData=$plugins[_0x209d9c(0x209)](function(_0x248a4c){const _0x57820b=_0x209d9c;return _0x248a4c[_0x57820b(0x2f7)]&&_0x248a4c[_0x57820b(0x142)][_0x57820b(0x283)]('['+label+']');})[0x0];VisuMZ[label]['Settings']=VisuMZ[label][_0x209d9c(0x20f)]||{},VisuMZ[_0x209d9c(0x131)]=function(_0x445384,_0x4c4d39){const _0xb7dea2=_0x209d9c;for(const _0x934d22 in _0x4c4d39){if(_0x934d22[_0xb7dea2(0x1b7)](/(.*):(.*)/i)){const _0x28bc35=String(RegExp['$1']),_0x450dea=String(RegExp['$2'])[_0xb7dea2(0x278)]()[_0xb7dea2(0x2e0)]();let _0x3acbf8,_0x85c6d0,_0x3afb52;switch(_0x450dea){case _0xb7dea2(0x216):_0x3acbf8=_0x4c4d39[_0x934d22]!==''?Number(_0x4c4d39[_0x934d22]):0x0;break;case'ARRAYNUM':_0x85c6d0=_0x4c4d39[_0x934d22]!==''?JSON[_0xb7dea2(0x24b)](_0x4c4d39[_0x934d22]):[],_0x3acbf8=_0x85c6d0[_0xb7dea2(0x183)](_0x14adc1=>Number(_0x14adc1));break;case _0xb7dea2(0x29b):_0x3acbf8=_0x4c4d39[_0x934d22]!==''?eval(_0x4c4d39[_0x934d22]):null;break;case _0xb7dea2(0x2eb):_0x85c6d0=_0x4c4d39[_0x934d22]!==''?JSON[_0xb7dea2(0x24b)](_0x4c4d39[_0x934d22]):[],_0x3acbf8=_0x85c6d0[_0xb7dea2(0x183)](_0x10b774=>eval(_0x10b774));break;case _0xb7dea2(0x20e):_0x3acbf8=_0x4c4d39[_0x934d22]!==''?JSON[_0xb7dea2(0x24b)](_0x4c4d39[_0x934d22]):'';break;case'ARRAYJSON':_0x85c6d0=_0x4c4d39[_0x934d22]!==''?JSON[_0xb7dea2(0x24b)](_0x4c4d39[_0x934d22]):[],_0x3acbf8=_0x85c6d0['map'](_0x537508=>JSON[_0xb7dea2(0x24b)](_0x537508));break;case'FUNC':_0x3acbf8=_0x4c4d39[_0x934d22]!==''?new Function(JSON[_0xb7dea2(0x24b)](_0x4c4d39[_0x934d22])):new Function(_0xb7dea2(0x2b1));break;case _0xb7dea2(0x1ee):_0x85c6d0=_0x4c4d39[_0x934d22]!==''?JSON[_0xb7dea2(0x24b)](_0x4c4d39[_0x934d22]):[],_0x3acbf8=_0x85c6d0['map'](_0x35503b=>new Function(JSON['parse'](_0x35503b)));break;case _0xb7dea2(0x1e9):_0x3acbf8=_0x4c4d39[_0x934d22]!==''?String(_0x4c4d39[_0x934d22]):'';break;case _0xb7dea2(0x1fb):_0x85c6d0=_0x4c4d39[_0x934d22]!==''?JSON[_0xb7dea2(0x24b)](_0x4c4d39[_0x934d22]):[],_0x3acbf8=_0x85c6d0[_0xb7dea2(0x183)](_0x2f76a4=>String(_0x2f76a4));break;case _0xb7dea2(0x258):_0x3afb52=_0x4c4d39[_0x934d22]!==''?JSON['parse'](_0x4c4d39[_0x934d22]):{},_0x3acbf8=VisuMZ['ConvertParams']({},_0x3afb52);break;case _0xb7dea2(0x29a):_0x85c6d0=_0x4c4d39[_0x934d22]!==''?JSON[_0xb7dea2(0x24b)](_0x4c4d39[_0x934d22]):[],_0x3acbf8=_0x85c6d0[_0xb7dea2(0x183)](_0x452f0e=>VisuMZ[_0xb7dea2(0x131)]({},JSON[_0xb7dea2(0x24b)](_0x452f0e)));break;default:continue;}_0x445384[_0x28bc35]=_0x3acbf8;}}return _0x445384;},(_0x2ade8d=>{const _0x2e8709=_0x209d9c,_0x3cb771=_0x2ade8d[_0x2e8709(0x241)];for(const _0x5235aa of dependencies){if('dIznm'===_0x2e8709(0x200))this['_victoryAftermathNewSkillQuotes']=_0x627836(_0x30f08c['$1'])[_0x2e8709(0x289)](/<NEW QUOTE>[\r\n]+/i);else{if(!Imported[_0x5235aa]){alert('%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.'['format'](_0x3cb771,_0x5235aa)),SceneManager['exit']();break;}}}const _0x4235d8=_0x2ade8d[_0x2e8709(0x142)];if(_0x4235d8[_0x2e8709(0x1b7)](/\[Version[ ](.*?)\]/i)){if(_0x2e8709(0x152)!==_0x2e8709(0x282)){const _0x4c788f=Number(RegExp['$1']);if(_0x4c788f!==VisuMZ[label][_0x2e8709(0x27a)]){if(_0x2e8709(0x2d7)===_0x2e8709(0x2d7))alert(_0x2e8709(0x293)[_0x2e8709(0x1a7)](_0x3cb771,_0x4c788f)),SceneManager[_0x2e8709(0x18c)]();else{this[_0x2e8709(0x19d)]++;if(this[_0x2e8709(0x19d)]>=_0xb1f45a[_0x2e8709(0x16b)]())return null;const _0x35ac28=_0x35931c[_0x2e8709(0x303)]()[this[_0x2e8709(0x19d)]],_0x21d646=this['_victoryTempActorsB'][this[_0x2e8709(0x19d)]];if(_0x35ac28[_0x2e8709(0x1f0)]!==_0x21d646['level'])return _0x35ac28;}}}else _0x5386e8[_0x2e8709(0x21a)]=!![];}if(_0x4235d8[_0x2e8709(0x1b7)](/\[Tier[ ](\d+)\]/i)){if('zbswG'!==_0x2e8709(0x193))_0x4c5274=_0x4591c3['level'],_0x5800a1=_0x1a1849[_0x2e8709(0x1f0)],_0x2eec8c=_0xb46a68-_0x4d8d3a;else{const _0x2cdf98=Number(RegExp['$1']);_0x2cdf98<tier?(alert('%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.'['format'](_0x3cb771,_0x2cdf98,tier)),SceneManager[_0x2e8709(0x18c)]()):_0x2e8709(0x227)==='elODQ'?tier=Math[_0x2e8709(0x18b)](_0x2cdf98,tier):(this[_0x2e8709(0x281)]=_0x2584b0,this[_0x2e8709(0x137)]=0x0);}}VisuMZ[_0x2e8709(0x131)](VisuMZ[label][_0x2e8709(0x20f)],_0x2ade8d[_0x2e8709(0x1fa)]);})(pluginData),PluginManager['registerCommand'](pluginData['name'],_0x209d9c(0x26e),_0x3295b3=>{const _0x5a1966=_0x209d9c;VisuMZ[_0x5a1966(0x131)](_0x3295b3,_0x3295b3);const _0x37b345=$gameActors[_0x5a1966(0x1e5)](_0x3295b3['ActorID']),_0x524d78=_0x3295b3[_0x5a1966(0x226)];if(_0x37b345)while(_0x524d78[_0x5a1966(0x2c7)]>0x0){_0x37b345['levelUpQuotes']()['push'](_0x524d78['shift']());}}),PluginManager[_0x209d9c(0x19e)](pluginData[_0x209d9c(0x241)],'ActorQuotesNewSkillAdd',_0x1b4bf5=>{const _0x4c7363=_0x209d9c;VisuMZ['ConvertParams'](_0x1b4bf5,_0x1b4bf5);const _0x153889=$gameActors[_0x4c7363(0x1e5)](_0x1b4bf5[_0x4c7363(0x150)]),_0x114cd2=_0x1b4bf5['NewQuotes'];if(_0x153889)while(_0x114cd2[_0x4c7363(0x2c7)]>0x0){'xzsZp'===_0x4c7363(0x14f)?this[_0x4c7363(0x1ae)][_0x4c7363(0x2dc)]=_0x2c81e[_0x4c7363(0x298)][_0x4c7363(0x2f5)]():_0x153889[_0x4c7363(0x233)]()[_0x4c7363(0x28c)](_0x114cd2['shift']());}}),PluginManager[_0x209d9c(0x19e)](pluginData['name'],_0x209d9c(0x17c),_0x58ddf0=>{const _0x414201=_0x209d9c;VisuMZ[_0x414201(0x131)](_0x58ddf0,_0x58ddf0);const _0x4f1f67=$gameActors[_0x414201(0x1e5)](_0x58ddf0[_0x414201(0x150)]);if(_0x4f1f67)while(_0x4f1f67[_0x414201(0x2ee)]()[_0x414201(0x2c7)]>0x0){if(_0x414201(0x308)!==_0x414201(0x308))return this[_0x414201(0x1e5)]()[_0x414201(0x174)]()?_0x29c3f3[_0x414201(0x2ec)]?_0x4dd1d7[_0x414201(0x312)]():_0x44cc28['textColor'](0xe):_0x485374[_0x414201(0x2ec)]?_0x4edbf7['expGaugeColor1']():_0x41cec4[_0x414201(0x2ac)](0x1e);else _0x4f1f67[_0x414201(0x2ee)]()['shift']();}}),PluginManager[_0x209d9c(0x19e)](pluginData[_0x209d9c(0x241)],_0x209d9c(0x263),_0x49a7d9=>{const _0x5c9f11=_0x209d9c;VisuMZ[_0x5c9f11(0x131)](_0x49a7d9,_0x49a7d9);const _0x4853a6=$gameActors['actor'](_0x49a7d9['ActorID']);if(_0x4853a6)while(_0x4853a6[_0x5c9f11(0x233)]()[_0x5c9f11(0x2c7)]>0x0){_0x4853a6[_0x5c9f11(0x233)]()[_0x5c9f11(0x26d)]();}}),PluginManager[_0x209d9c(0x19e)](pluginData[_0x209d9c(0x241)],_0x209d9c(0x276),_0x36a27f=>{const _0xbf0813=_0x209d9c;VisuMZ[_0xbf0813(0x131)](_0x36a27f,_0x36a27f),$gameSystem[_0xbf0813(0x30a)]()['bypassVictoryMotion']=_0x36a27f['Bypass'];}),PluginManager[_0x209d9c(0x19e)](pluginData[_0x209d9c(0x241)],_0x209d9c(0x299),_0x3fbba3=>{const _0x48b3e4=_0x209d9c;VisuMZ[_0x48b3e4(0x131)](_0x3fbba3,_0x3fbba3),$gameSystem['victoryAftermathSettings']()[_0x48b3e4(0x292)]=_0x3fbba3['Bypass'];}),PluginManager[_0x209d9c(0x19e)](pluginData[_0x209d9c(0x241)],_0x209d9c(0x195),_0x2e8f7a=>{const _0x37c32d=_0x209d9c;VisuMZ['ConvertParams'](_0x2e8f7a,_0x2e8f7a),$gameSystem[_0x37c32d(0x30a)]()['bypassVictoryPhase']=_0x2e8f7a['Bypass'];}),TextManager[_0x209d9c(0x22a)]=VisuMZ[_0x209d9c(0x315)][_0x209d9c(0x20f)][_0x209d9c(0x13c)][_0x209d9c(0x287)],TextManager[_0x209d9c(0x214)]=VisuMZ['VictoryAftermath'][_0x209d9c(0x20f)][_0x209d9c(0x13c)][_0x209d9c(0x317)],TextManager['victoryKeyCancel']=VisuMZ[_0x209d9c(0x315)][_0x209d9c(0x20f)][_0x209d9c(0x13c)][_0x209d9c(0x166)],TextManager[_0x209d9c(0x22e)]=VisuMZ[_0x209d9c(0x315)][_0x209d9c(0x20f)][_0x209d9c(0x13c)]['LvFmt'],TextManager['victoryDisplayLvUp']=VisuMZ[_0x209d9c(0x315)][_0x209d9c(0x20f)]['Vocab'][_0x209d9c(0x2b5)],TextManager[_0x209d9c(0x1c8)]=VisuMZ[_0x209d9c(0x315)][_0x209d9c(0x20f)][_0x209d9c(0x13c)][_0x209d9c(0x2c8)],TextManager[_0x209d9c(0x143)]=VisuMZ['VictoryAftermath']['Settings'][_0x209d9c(0x13c)]['Victory'],TextManager[_0x209d9c(0x2b9)]=VisuMZ[_0x209d9c(0x315)]['Settings'][_0x209d9c(0x13c)][_0x209d9c(0x2a9)],TextManager[_0x209d9c(0x2d2)]=function(_0x105ac7){const _0x5278f=_0x209d9c,_0x48502f=VisuMZ[_0x5278f(0x315)]['Settings'][_0x5278f(0x17b)][_0x5278f(0x16f)];if(!_0x105ac7)return _0x48502f[Math['randomInt'](_0x48502f[_0x5278f(0x2c7)])];if(!_0x105ac7['isActor']())return _0x48502f[Math[_0x5278f(0x21e)](_0x48502f[_0x5278f(0x2c7)])];const _0xfaf2d2=_0x105ac7[_0x5278f(0x2ee)]();if(_0xfaf2d2[_0x5278f(0x2c7)]>0x0)return _0xfaf2d2[Math[_0x5278f(0x21e)](_0xfaf2d2[_0x5278f(0x2c7)])];return _0x48502f[Math[_0x5278f(0x21e)](_0x48502f['length'])];},TextManager[_0x209d9c(0x264)]=function(_0x294100){const _0xb1f93f=_0x209d9c,_0x147bea=VisuMZ[_0xb1f93f(0x315)][_0xb1f93f(0x20f)][_0xb1f93f(0x17b)]['NewSkillQuotes'];if(!_0x294100)return _0x147bea[Math[_0xb1f93f(0x21e)](_0x147bea[_0xb1f93f(0x2c7)])];if(!_0x294100[_0xb1f93f(0x14c)]())return _0x147bea[Math['randomInt'](_0x147bea['length'])];const _0x22430c=_0x294100[_0xb1f93f(0x233)]();if(_0x22430c['length']>0x0)return _0x22430c[Math[_0xb1f93f(0x21e)](_0x22430c[_0xb1f93f(0x2c7)])];return _0x147bea[Math[_0xb1f93f(0x21e)](_0x147bea['length'])];},ColorManager[_0x209d9c(0x1c5)]=function(_0x11492e,_0x197f6c){const _0x1396f4=_0x209d9c;_0x197f6c=String(_0x197f6c),this[_0x1396f4(0x2d6)]=this['_colorCache']||{};if(_0x197f6c[_0x1396f4(0x1b7)](/#(.*)/i)){if(_0x1396f4(0x22b)!==_0x1396f4(0x1fc))this['_colorCache'][_0x11492e]=_0x1396f4(0x18f)[_0x1396f4(0x1a7)](String(RegExp['$1']));else{if(this[_0x1396f4(0x174)]())return 0x1;const _0x1e3a9c=this[_0x1396f4(0x274)]()-this[_0x1396f4(0x272)](),_0x3bd3e6=this[_0x1396f4(0x253)]()-this[_0x1396f4(0x272)]();return(_0x3bd3e6/_0x1e3a9c)[_0x1396f4(0x2b2)](0x0,0x1);}}else{if('BlNMk'===_0x1396f4(0x2b0))this[_0x1396f4(0x2d6)][_0x11492e]=this[_0x1396f4(0x2ac)](Number(_0x197f6c));else{const _0xedb48f=this[_0x1396f4(0x172)](),_0x480fd5=_0x4c2b73['_showFace'],_0xcb951a=this['getQuoteWidth'](),_0x47dd3c=_0xedb48f*0x4,_0x527004=_0x4e65a2[_0x1396f4(0x297)]((this[_0x1396f4(0x1a8)]-_0xcb951a)/0x2),_0x472978=_0x527004+(_0x480fd5?_0x51a1fc[_0x1396f4(0x202)]+0x14:0x0),_0x160765=this[_0x1396f4(0x15b)]-_0xedb48f*5.5;let _0x5c2ee8=this[_0x1396f4(0x17a)]();_0x480fd5&&this[_0x1396f4(0x265)](this['_actor'],_0x527004,_0x160765,_0x5189ed[_0x1396f4(0x202)],_0x1357d8[_0x1396f4(0x153)]),this['drawTextEx'](_0x5c2ee8,_0x472978,_0x160765,_0xcb951a-_0x472978);}}return this[_0x1396f4(0x2d6)][_0x11492e];},ColorManager[_0x209d9c(0x2e6)]=function(_0x1716e7){const _0x448d35=_0x209d9c;_0x1716e7=String(_0x1716e7);if(_0x1716e7[_0x448d35(0x1b7)](/#(.*)/i)){if(_0x448d35(0x288)==='BlEZH')return _0x448d35(0x18f)['format'](String(RegExp['$1']));else this[_0x448d35(0x17d)]={'bypassVictoryMusic':![],'bypassVictoryPhase':![],'bypassVictoryMotion':![]};}else return this[_0x448d35(0x2ac)](Number(_0x1716e7));},ColorManager[_0x209d9c(0x1db)]=function(){const _0xd8550=_0x209d9c,_0x232fa7=_0xd8550(0x25a);this[_0xd8550(0x2d6)]=this[_0xd8550(0x2d6)]||{};if(this['_colorCache'][_0x232fa7])return this[_0xd8550(0x2d6)][_0x232fa7];const _0x25820c=VisuMZ['VictoryAftermath']['Settings'][_0xd8550(0x13c)][_0xd8550(0x275)];return this[_0xd8550(0x1c5)](_0x232fa7,_0x25820c);},SoundManager['playVictoryLevelUpSFX']=function(){const _0xdcdb71=_0x209d9c;if(this[_0xdcdb71(0x151)])return;if(!this[_0xdcdb71(0x1d0)]){if(_0xdcdb71(0x1a5)!==_0xdcdb71(0x1a5)){const _0x1d1c14=this[_0xdcdb71(0x266)];if(_0x1d1c14[_0x2e8248])return _0x1d1c14[_0x853cc1];else{const _0x4bd890=new _0x294440(_0x388f83,this,_0x2f8edf);return _0x1d1c14[_0x5db785]=_0x4bd890,this['addInnerChild'](_0x4bd890),_0x4bd890;}}else{const _0x511aaf=VisuMZ[_0xdcdb71(0x315)][_0xdcdb71(0x20f)][_0xdcdb71(0x13c)];this['_victoryLevelUpSFX']={'name':_0x511aaf[_0xdcdb71(0x213)]||'','volume':_0x511aaf[_0xdcdb71(0x2c3)]??0x5a,'pitch':_0x511aaf['LvUpPitch']??0x64,'pan':_0x511aaf[_0xdcdb71(0x1d7)]??0x0};}}if(this[_0xdcdb71(0x1d0)][_0xdcdb71(0x241)]!==''){if(_0xdcdb71(0x13a)==='nDizD')return _0x59dd8b[_0xdcdb71(0x1df)]('ok')||_0x488be4[_0xdcdb71(0x1df)]('cancel')||_0x34e454[_0xdcdb71(0x1df)]();else AudioManager[_0xdcdb71(0x19c)](this['_victoryLevelUpSFX']),this[_0xdcdb71(0x151)]=!![],setTimeout(this['removeVictoryLevelUpBuffer'][_0xdcdb71(0x1a9)](this),0xc8);}},SoundManager[_0x209d9c(0x2c1)]=function(){const _0x454513=_0x209d9c;this[_0x454513(0x151)]=![];},SoundManager[_0x209d9c(0x2da)]=function(){const _0x4c754d=_0x209d9c;if(!this[_0x4c754d(0x15a)]){const _0x5ddf68=VisuMZ[_0x4c754d(0x315)][_0x4c754d(0x20f)][_0x4c754d(0x313)];if(_0x5ddf68[_0x4c754d(0x30f)]===undefined)_0x5ddf68[_0x4c754d(0x30f)]=0x5a;if(_0x5ddf68[_0x4c754d(0x169)]===undefined)_0x5ddf68[_0x4c754d(0x169)]=0x64;if(_0x5ddf68['pan']===undefined)_0x5ddf68['pan']=0x0;this['_victoryBgm']={'name':_0x5ddf68[_0x4c754d(0x2ed)]||'','volume':_0x5ddf68['volume']||0x0,'pitch':_0x5ddf68[_0x4c754d(0x169)]||0x0,'pan':_0x5ddf68['pan']||0x0};}if(this['_victoryBgm']['name']!==''){if(_0x4c754d(0x140)!==_0x4c754d(0x2b8))AudioManager[_0x4c754d(0x296)](this[_0x4c754d(0x15a)]);else return!![];}},BattleManager[_0x209d9c(0x147)]=VisuMZ[_0x209d9c(0x315)]['Settings']['General'][_0x209d9c(0x15c)]||0x1,VisuMZ['VictoryAftermath']['BattleManager_initMembers']=BattleManager['initMembers'],BattleManager[_0x209d9c(0x2e4)]=function(){const _0x5e4bb5=_0x209d9c;VisuMZ[_0x5e4bb5(0x315)][_0x5e4bb5(0x194)][_0x5e4bb5(0x1ef)](this),this[_0x5e4bb5(0x2db)]=![],this['_victoryActorIndex']=-0x1,this[_0x5e4bb5(0x23e)]=![];},VisuMZ[_0x209d9c(0x315)][_0x209d9c(0x203)]=BattleManager[_0x209d9c(0x2e7)],BattleManager[_0x209d9c(0x2e7)]=function(){const _0x4b689f=_0x209d9c;return this[_0x4b689f(0x1be)]()?!![]:VisuMZ[_0x4b689f(0x315)][_0x4b689f(0x203)][_0x4b689f(0x1ef)](this);},BattleManager[_0x209d9c(0x1be)]=function(){const _0x4eb679=_0x209d9c;return this[_0x4eb679(0x1c1)]==='battleEnd'&&this['_victoryPhase'];},BattleManager[_0x209d9c(0x262)]=function(){const _0x33ad0c=_0x209d9c;this[_0x33ad0c(0x2fd)](_0x33ad0c(0x1a4)),this[_0x33ad0c(0x243)](_0x33ad0c(0x300)),this[_0x33ad0c(0x1fd)]();},BattleManager['processVictoryAftermath']=function(){const _0xccc847=_0x209d9c;this[_0xccc847(0x138)](),this[_0xccc847(0x12f)](),this[_0xccc847(0x25c)](),this[_0xccc847(0x196)]();},BattleManager[_0x209d9c(0x138)]=function(){const _0x39fe86=_0x209d9c;$gameParty['removeBattleStates'](),$gameParty[_0x39fe86(0x1b0)]();},BattleManager[_0x209d9c(0x12f)]=function(){const _0x25b976=_0x209d9c;if(this[_0x25b976(0x132)]())return;this[_0x25b976(0x1da)](),SoundManager[_0x25b976(0x2da)]();},BattleManager[_0x209d9c(0x132)]=function(){const _0x21bc6a=_0x209d9c;return $gameSystem[_0x21bc6a(0x30a)]()[_0x21bc6a(0x292)]||$gameSystem[_0x21bc6a(0x30a)]()['bypassVictoryPhase'];},BattleManager[_0x209d9c(0x25c)]=function(){const _0xff3ded=_0x209d9c;this['makeTempActors'](),this[_0xff3ded(0x159)](),this[_0xff3ded(0x23b)]();},BattleManager[_0x209d9c(0x16c)]=function(){const _0xdb82eb=_0x209d9c;this[_0xdb82eb(0x208)]=$gameParty['battleMembers']()[_0xdb82eb(0x183)](_0x3b277c=>_0x3b277c[_0xdb82eb(0x304)]()),this[_0xdb82eb(0x18a)]=JsonEx[_0xdb82eb(0x170)](this[_0xdb82eb(0x208)]);},BattleManager[_0x209d9c(0x196)]=function(){const _0x26661d=_0x209d9c;this[_0x26661d(0x1bd)](),this[_0x26661d(0x240)](0x0),this[_0x26661d(0x2db)]=!![],this[_0x26661d(0x2fa)]()?_0x26661d(0x205)===_0x26661d(0x205)?this[_0x26661d(0x2a8)]():_0x38efe4=_0x593e97[_0x26661d(0x1ab)](_0x41d589):this[_0x26661d(0x306)]();},BattleManager[_0x209d9c(0x1bd)]=function(){const _0x57eecc=_0x209d9c,_0x1918c8=VisuMZ[_0x57eecc(0x315)][_0x57eecc(0x20f)][_0x57eecc(0x313)];_0x1918c8[_0x57eecc(0x21a)]===undefined&&(_0x1918c8[_0x57eecc(0x21a)]=!![]),_0x1918c8[_0x57eecc(0x21a)]===!![]&&(this[_0x57eecc(0x23e)]=this[_0x57eecc(0x28a)]);},BattleManager[_0x209d9c(0x2fa)]=function(){const _0x426018=_0x209d9c;if(this['_autoBattleVictorySkip'])return!![];return $gameSystem[_0x426018(0x30a)]()['bypassVictoryPhase'];},BattleManager[_0x209d9c(0x2a8)]=function(){const _0xed1e7e=_0x209d9c,_0x54704f=VisuMZ[_0xed1e7e(0x315)][_0xed1e7e(0x20f)]['General'],_0x4d491d=SceneManager[_0xed1e7e(0x2ff)];setTimeout(_0x4d491d[_0xed1e7e(0x2ca)]['bind'](_0x4d491d),_0x54704f[_0xed1e7e(0x2fc)]);},BattleManager[_0x209d9c(0x306)]=function(){const _0x11dc1a=_0x209d9c,_0x3151e2=VisuMZ[_0x11dc1a(0x315)]['Settings'][_0x11dc1a(0x313)],_0x50c648=SceneManager[_0x11dc1a(0x2ff)];this['_tempActorExpGain']=this['_rewards']['exp']/(BattleManager[_0x11dc1a(0x147)]||0x1),Window_StatusBase['prototype'][_0x11dc1a(0x178)](),setTimeout(_0x50c648[_0x11dc1a(0x21c)][_0x11dc1a(0x1a9)](_0x50c648),_0x3151e2[_0x11dc1a(0x215)]),setTimeout(_0x50c648[_0x11dc1a(0x1f1)]['bind'](_0x50c648),_0x3151e2['ShowDelayMS']);},BattleManager[_0x209d9c(0x212)]=function(){const _0x1a1118=_0x209d9c;for(;;){if('Dakjf'!==_0x1a1118(0x222)){this[_0x1a1118(0x19d)]++;if(this['_victoryActorIndex']>=$gameParty[_0x1a1118(0x16b)]())return null;const _0x48d3eb=$gameParty[_0x1a1118(0x303)]()[this[_0x1a1118(0x19d)]],_0x3e8d35=this[_0x1a1118(0x18a)][this['_victoryActorIndex']];if(_0x48d3eb['level']!==_0x3e8d35[_0x1a1118(0x1f0)])return _0x48d3eb;}else return _0x7ac74b['isSceneBattle']()?![]:_0x184a1f[_0x1a1118(0x315)]['Game_Actor_shouldDisplayLevelUp']['call'](this);}return null;},VisuMZ[_0x209d9c(0x315)][_0x209d9c(0x2bf)]=Game_System[_0x209d9c(0x298)][_0x209d9c(0x1f3)],Game_System[_0x209d9c(0x298)][_0x209d9c(0x1f3)]=function(){const _0x2ce30a=_0x209d9c;VisuMZ['VictoryAftermath'][_0x2ce30a(0x2bf)][_0x2ce30a(0x1ef)](this),this[_0x2ce30a(0x218)]();},Game_System[_0x209d9c(0x298)][_0x209d9c(0x218)]=function(){const _0x4db0f2=_0x209d9c;this[_0x4db0f2(0x17d)]={'bypassVictoryMusic':![],'bypassVictoryPhase':![],'bypassVictoryMotion':![]};},Game_System[_0x209d9c(0x298)]['victoryAftermathSettings']=function(){const _0x343a2a=_0x209d9c;if(this['_victoryAftermathSettings']===undefined)this[_0x343a2a(0x218)]();return this['_victoryAftermathSettings'];},VisuMZ[_0x209d9c(0x315)][_0x209d9c(0x27b)]=Game_Actor[_0x209d9c(0x298)][_0x209d9c(0x251)],Game_Actor[_0x209d9c(0x298)]['setup']=function(_0x3a2a87){const _0x32a765=_0x209d9c;VisuMZ[_0x32a765(0x315)][_0x32a765(0x27b)]['call'](this,_0x3a2a87),this[_0x32a765(0x269)]();},Game_Actor['prototype']['setupVictoryAftermathQuotes']=function(){const _0x7ddf7=_0x209d9c;this[_0x7ddf7(0x1bb)]=[],this[_0x7ddf7(0x1cf)]=[];const _0x246f34=this[_0x7ddf7(0x1e5)]()['note'];_0x246f34[_0x7ddf7(0x1b7)](/<LEVEL UP (?:QUOTE|QUOTES)>\s*([\s\S]*)\s*<\/LEVEL UP (?:QUOTE|QUOTES)>/i)&&(this[_0x7ddf7(0x1bb)]=String(RegExp['$1'])[_0x7ddf7(0x289)](/<NEW QUOTE>[\r\n]+/i)),_0x246f34[_0x7ddf7(0x1b7)](/<NEW SKILL (?:QUOTE|QUOTES)>\s*([\s\S]*)\s*<\/NEW SKILL (?:QUOTE|QUOTES)>/i)&&(this[_0x7ddf7(0x1cf)]=String(RegExp['$1'])[_0x7ddf7(0x289)](/<NEW QUOTE>[\r\n]+/i));},Game_Actor[_0x209d9c(0x298)][_0x209d9c(0x2ee)]=function(){if(this['_victoryAftermathLevelUpQuotes']===undefined)this['setupVictoryAftermathQuotes']();return this['_victoryAftermathLevelUpQuotes'];},Game_Actor[_0x209d9c(0x298)][_0x209d9c(0x233)]=function(){const _0x2837d4=_0x209d9c;if(this[_0x2837d4(0x1cf)]===undefined)this[_0x2837d4(0x269)]();return this[_0x2837d4(0x1cf)];},Game_Actor[_0x209d9c(0x298)][_0x209d9c(0x16e)]=function(){const _0x5a8536=_0x209d9c;if(this['isMaxLevel']())return 0x1;const _0x65f4e0=this['nextLevelExp']()-this[_0x5a8536(0x272)](),_0x135c50=this[_0x5a8536(0x253)]()-this[_0x5a8536(0x272)]();return(_0x135c50/_0x65f4e0)[_0x5a8536(0x2b2)](0x0,0x1);},VisuMZ[_0x209d9c(0x315)][_0x209d9c(0x29e)]=Game_Actor['prototype'][_0x209d9c(0x2c0)],Game_Actor['prototype'][_0x209d9c(0x2c0)]=function(){const _0x140b75=_0x209d9c;return SceneManager[_0x140b75(0x2dd)]()?![]:VisuMZ['VictoryAftermath'][_0x140b75(0x29e)][_0x140b75(0x1ef)](this);},Game_Actor[_0x209d9c(0x298)][_0x209d9c(0x304)]=function(){const _0x5e4d26=_0x209d9c,_0x2ede3a=JsonEx['makeDeepCopy'](this);return _0x2ede3a[_0x5e4d26(0x1d1)]=!![],_0x2ede3a;},VisuMZ[_0x209d9c(0x315)][_0x209d9c(0x2ce)]=Game_Actor['prototype'][_0x209d9c(0x1d4)],Game_Actor[_0x209d9c(0x298)][_0x209d9c(0x1d4)]=function(){const _0x147796=_0x209d9c;if(this['_victoryAftermathCopy'])return!![];else{if('utKyy'==='KsDkZ'){if(this[_0x147796(0x17d)]===_0x15dc7d)this[_0x147796(0x218)]();return this[_0x147796(0x17d)];}else return VisuMZ[_0x147796(0x315)]['Game_Actor_isBattleMember']['call'](this);}},VisuMZ[_0x209d9c(0x315)][_0x209d9c(0x260)]=Game_Actor['prototype'][_0x209d9c(0x1b0)],Game_Actor[_0x209d9c(0x298)][_0x209d9c(0x1b0)]=function(){const _0x4e585f=_0x209d9c;this[_0x4e585f(0x1af)]()?this[_0x4e585f(0x23f)]('done'):VisuMZ[_0x4e585f(0x315)]['Game_Actor_performVictory']['call'](this);},Game_Actor[_0x209d9c(0x298)]['isBypassVictoryAftermathMotion']=function(){const _0x19c50c=_0x209d9c;return $gameSystem[_0x19c50c(0x30a)]()[_0x19c50c(0x198)]||$gameSystem[_0x19c50c(0x30a)]()[_0x19c50c(0x257)];},Scene_Battle[_0x209d9c(0x298)][_0x209d9c(0x21c)]=function(){const _0x15457a=_0x209d9c;if(this[_0x15457a(0x1c7)][_0x15457a(0x249)]())return setTimeout(this['hideWindowsForVictoryAftermath']['bind'](this),0x7d0);if(!SceneManager[_0x15457a(0x2dd)]())return;this['setVisibleUI'](![]),this[_0x15457a(0x164)](),this[_0x15457a(0x305)](),this['_statusWindow']['y']=Graphics[_0x15457a(0x15b)]*0xa;},Scene_Battle[_0x209d9c(0x298)]['createVictoryAftermathWindows']=function(){const _0x5deb64=_0x209d9c;if(this[_0x5deb64(0x1c7)][_0x5deb64(0x249)]())return _0x5deb64(0x26b)===_0x5deb64(0x26b)?setTimeout(this[_0x5deb64(0x1f1)][_0x5deb64(0x1a9)](this),0x7d0):_0x4cbe45[_0x5deb64(0x2f7)]&&_0x2c5307[_0x5deb64(0x142)][_0x5deb64(0x283)]('['+_0x548355+']');this[_0x5deb64(0x26a)]=[],this[_0x5deb64(0x235)](),this[_0x5deb64(0x2a3)](),this['updateVictorySteps']();},Scene_Battle[_0x209d9c(0x298)]['createVictorySteps']=function(){const _0x3f48be=_0x209d9c;this[_0x3f48be(0x252)]=[],this['createVictoryStepRewards'](),this[_0x3f48be(0x295)]();},Scene_Battle[_0x209d9c(0x298)]['createVictoryStepRewards']=function(){const _0x4f1ce3=_0x209d9c;this[_0x4f1ce3(0x252)][_0x4f1ce3(0x28c)]('rewards');},Scene_Battle[_0x209d9c(0x298)][_0x209d9c(0x295)]=function(){const _0x631bba=_0x209d9c;if(!this[_0x631bba(0x1ed)]())return;for(const _0x50f4f7 of $gameParty['battleMembers']()){if(!_0x50f4f7)continue;const _0x45f6a4=BattleManager[_0x631bba(0x208)][_0x50f4f7[_0x631bba(0x168)]()];_0x50f4f7[_0x631bba(0x1f0)]>_0x45f6a4[_0x631bba(0x1f0)]&&this['onVictoryStepLevelUpMember'](_0x50f4f7);}},Scene_Battle[_0x209d9c(0x298)][_0x209d9c(0x146)]=function(_0x3b1ef2){const _0x4d3026=_0x209d9c;Imported[_0x4d3026(0x221)]&&Window_VictoryLevelUp[_0x4d3026(0x229)]&&ImageManager[_0x4d3026(0x14b)](_0x3b1ef2[_0x4d3026(0x141)]()),this['_victorySteps'][_0x4d3026(0x28c)]('levelups');},Scene_Battle['prototype'][_0x209d9c(0x1ed)]=function(){const _0x236680=_0x209d9c;return VisuMZ[_0x236680(0x315)][_0x236680(0x20f)][_0x236680(0x17b)][_0x236680(0x2be)];},Scene_Battle[_0x209d9c(0x298)]['updateVictorySteps']=function(){const _0x570a4e=_0x209d9c;this[_0x570a4e(0x1e3)]=this[_0x570a4e(0x252)][_0x570a4e(0x26d)]()||'',this[_0x570a4e(0x145)]();},Scene_Battle['prototype'][_0x209d9c(0x145)]=function(){const _0x52f393=_0x209d9c;switch(this[_0x52f393(0x1e3)][_0x52f393(0x220)]()[_0x52f393(0x2e0)]()){case _0x52f393(0x1b3):this['createVictoryRewardsWindow'](),this[_0x52f393(0x177)][_0x52f393(0x2f0)](BattleManager[_0x52f393(0x147)]);break;case _0x52f393(0x254):this[_0x52f393(0x239)](),this[_0x52f393(0x217)](),this[_0x52f393(0x177)][_0x52f393(0x2f0)](0x0);break;default:this[_0x52f393(0x2ca)]();break;}this[_0x52f393(0x207)](this[_0x52f393(0x177)]);},Scene_Battle['prototype'][_0x209d9c(0x20d)]=function(){const _0x4e0d72=_0x209d9c,_0x2b4027=Window_Base['prototype']['lineHeight'](),_0x196650=Math[_0x4e0d72(0x297)](Graphics[_0x4e0d72(0x1a8)]/0x2)-0x64,_0x18fdf0=Math[_0x4e0d72(0x297)](Graphics['height']-_0x2b4027*1.25),_0x5a3589=Math[_0x4e0d72(0x297)](Graphics[_0x4e0d72(0x1a8)]/0x2),_0x2a9eed=_0x2b4027;return new Rectangle(_0x196650,_0x18fdf0,_0x5a3589,_0x2a9eed);},Scene_Battle[_0x209d9c(0x298)][_0x209d9c(0x188)]=function(){const _0x2bdade=_0x209d9c,_0xfc379d=0x0,_0x53f296=0x0,_0x4e6f24=Graphics[_0x2bdade(0x1a8)],_0x169321=Graphics[_0x2bdade(0x15b)];return new Rectangle(_0xfc379d,_0x53f296,_0x4e6f24,_0x169321);},Scene_Battle[_0x209d9c(0x298)][_0x209d9c(0x2a3)]=function(){const _0x23a0f5=_0x209d9c;if(this[_0x23a0f5(0x177)])return;const _0x13212f=this['victoryContinueMessageWindowRect'](),_0x4232c0=new Window_VictoryContinueMessage(_0x13212f);this[_0x23a0f5(0x207)](_0x4232c0),this[_0x23a0f5(0x26a)]['push'](_0x4232c0),this['_victoryContinueWindow']=_0x4232c0;},Scene_Battle[_0x209d9c(0x298)][_0x209d9c(0x1de)]=function(){const _0x49a2e4=_0x209d9c;if(this['_victoryRewardsWindow'])return;const _0x36cdb8=this['victoryFullScreenWindowRect'](),_0x2aa21a=new Window_VictoryRewards(_0x36cdb8);this[_0x49a2e4(0x207)](_0x2aa21a),this[_0x49a2e4(0x26a)][_0x49a2e4(0x28c)](_0x2aa21a),this['_victoryRewardsWindow']=_0x2aa21a;},Scene_Battle[_0x209d9c(0x298)][_0x209d9c(0x239)]=function(){const _0x6aad33=_0x209d9c;if(this[_0x6aad33(0x1e1)])return;const _0xc3d252=this[_0x6aad33(0x188)](),_0x442612=new Window_VictoryLevelUp(_0xc3d252);this[_0x6aad33(0x207)](_0x442612),this['_victoryWindows'][_0x6aad33(0x28c)](_0x442612),this['_victoryLevelUpWindow']=_0x442612;},Scene_Battle['prototype'][_0x209d9c(0x217)]=function(){const _0x15c7f9=_0x209d9c,_0x1f8078=BattleManager[_0x15c7f9(0x212)]();this[_0x15c7f9(0x1e1)]['setActor'](_0x1f8078);},Scene_Battle[_0x209d9c(0x298)]['finishVictoryPhase']=function(){const _0x1a3fa3=_0x209d9c;BattleManager[_0x1a3fa3(0x28b)](),BattleManager[_0x1a3fa3(0x2db)]=![];};Imported[_0x209d9c(0x16a)]&&(VisuMZ[_0x209d9c(0x315)][_0x209d9c(0x1ba)]=Scene_Battle[_0x209d9c(0x298)][_0x209d9c(0x22c)],Scene_Battle[_0x209d9c(0x298)][_0x209d9c(0x22c)]=function(){const _0x2d518c=_0x209d9c;if(BattleManager['isVictoryPhase']())return![];return VisuMZ[_0x2d518c(0x315)]['Scene_Battle_allowUpdateBattleAniSpeed'][_0x2d518c(0x1ef)](this);});;Scene_Battle[_0x209d9c(0x298)]['isVictoryContinueReady']=function(){const _0x31957f=_0x209d9c;return this[_0x31957f(0x177)]&&this[_0x31957f(0x177)][_0x31957f(0x201)]();},VisuMZ[_0x209d9c(0x315)][_0x209d9c(0x1fe)]=Scene_Battle[_0x209d9c(0x298)][_0x209d9c(0x161)],Scene_Battle[_0x209d9c(0x298)][_0x209d9c(0x161)]=function(){const _0x2e342e=_0x209d9c;VisuMZ[_0x2e342e(0x315)][_0x2e342e(0x1fe)][_0x2e342e(0x1ef)](this),this[_0x2e342e(0x310)]();},Scene_Battle[_0x209d9c(0x298)][_0x209d9c(0x310)]=function(){const _0x522d9c=_0x209d9c;if(!BattleManager['isVictoryPhase']())return;if(!this[_0x522d9c(0x23d)]())return;(Input[_0x522d9c(0x2f4)]('ok')||Input[_0x522d9c(0x2f4)](_0x522d9c(0x1f8))||TouchInput[_0x522d9c(0x2f4)]())&&(Input['clear'](),TouchInput[_0x522d9c(0x1c2)](),this[_0x522d9c(0x2b4)]());},Sprite_Enemy['prototype'][_0x209d9c(0x249)]=function(){const _0xf8836d=_0x209d9c,_0x59e681=VisuMZ[_0xf8836d(0x315)][_0xf8836d(0x20f)][_0xf8836d(0x313)];if(this[_0xf8836d(0x2ab)]===_0xf8836d(0x237)){if(_0xf8836d(0x24e)===_0xf8836d(0x24e)){if(_0x59e681[_0xf8836d(0x1b4)]!==undefined)return _0x59e681[_0xf8836d(0x1b4)];}else while(_0x4cb1a5[_0xf8836d(0x2c7)]>0x0){_0x5d981d[_0xf8836d(0x2ee)]()[_0xf8836d(0x28c)](_0x4afd76[_0xf8836d(0x26d)]());}}else{if(this[_0xf8836d(0x2ab)]===_0xf8836d(0x204)){if(_0x59e681[_0xf8836d(0x25d)]!==undefined)return _0x59e681[_0xf8836d(0x25d)];}}return[_0xf8836d(0x237),_0xf8836d(0x204)][_0xf8836d(0x283)]();},Sprite_Battler[_0x209d9c(0x298)][_0x209d9c(0x249)]=function(){return![];},Spriteset_Battle[_0x209d9c(0x298)]['isCollapsing']=function(){const _0x54c71c=_0x209d9c;return this[_0x54c71c(0x316)]()[_0x54c71c(0x2fb)](_0x452274=>_0x452274[_0x54c71c(0x249)]());};function Sprite_VictoryGauge(){const _0x86e994=_0x209d9c;this[_0x86e994(0x1f3)](...arguments);}Sprite_VictoryGauge['prototype']=Object[_0x209d9c(0x270)](Sprite[_0x209d9c(0x298)]),Sprite_VictoryGauge['prototype'][_0x209d9c(0x14a)]=Sprite_VictoryGauge,Sprite_VictoryGauge[_0x209d9c(0x298)][_0x209d9c(0x1f3)]=function(_0x4eed82,_0x578ef9,_0x51a5c5){const _0x554ca7=_0x209d9c;this[_0x554ca7(0x19a)]=_0x4eed82,this[_0x554ca7(0x2e2)]=_0x578ef9,this[_0x554ca7(0x175)]=_0x51a5c5,Sprite[_0x554ca7(0x298)][_0x554ca7(0x1f3)][_0x554ca7(0x1ef)](this),this[_0x554ca7(0x2e4)](),this[_0x554ca7(0x1d5)](),this[_0x554ca7(0x286)](),this[_0x554ca7(0x1ea)]();},Sprite_VictoryGauge[_0x209d9c(0x298)][_0x209d9c(0x2e4)]=function(){const _0x5c6b8a=_0x209d9c;this[_0x5c6b8a(0x1cc)]=BattleManager['_victoryUpdateDuration'],this['_currentlevel']=this[_0x5c6b8a(0x1e5)]()[_0x5c6b8a(0x1f0)],this[_0x5c6b8a(0x25b)]=![];},Sprite_VictoryGauge[_0x209d9c(0x298)]['createBitmap']=function(){const _0x29a80b=_0x209d9c;this[_0x29a80b(0x2f8)]=new Bitmap(this[_0x29a80b(0x175)],this[_0x29a80b(0x172)]()*0x2);},Sprite_VictoryGauge[_0x209d9c(0x298)][_0x209d9c(0x172)]=function(){const _0x10cb78=_0x209d9c;return Window_Base[_0x10cb78(0x298)][_0x10cb78(0x172)]();},Sprite_VictoryGauge['prototype'][_0x209d9c(0x1e5)]=function(){return BattleManager['_victoryTempActorsA'][this['_index']];},Sprite_VictoryGauge['prototype'][_0x209d9c(0x161)]=function(){const _0x303e0c=_0x209d9c;Sprite[_0x303e0c(0x298)]['update']['call'](this),this['updateExpGain'](),this[_0x303e0c(0x1ea)]();},Sprite_VictoryGauge[_0x209d9c(0x298)][_0x209d9c(0x22f)]=function(){const _0x21e9d2=_0x209d9c;if(this['_duration']<=0x0)return;const _0x1d0b61=this[_0x21e9d2(0x1e5)]();this[_0x21e9d2(0x1cc)]--;this[_0x21e9d2(0x25f)]()&&(this[_0x21e9d2(0x1cc)]=0x0);if(this[_0x21e9d2(0x1cc)]<=0x0){const _0x3c9f4b=$gameActors[_0x21e9d2(0x1e5)](_0x1d0b61[_0x21e9d2(0x1cb)]);_0x1d0b61[_0x21e9d2(0x267)](_0x3c9f4b['currentExp'](),![]);}else _0x1d0b61[_0x21e9d2(0x21d)](BattleManager[_0x21e9d2(0x1a3)]);this[_0x21e9d2(0x134)]!==_0x1d0b61[_0x21e9d2(0x1f0)]&&(this[_0x21e9d2(0x134)]=_0x1d0b61[_0x21e9d2(0x1f0)],this['_showLevelUp']=!![],SoundManager[_0x21e9d2(0x1d3)]()),this[_0x21e9d2(0x286)]();},Game_Actor[_0x209d9c(0x298)][_0x209d9c(0x21d)]=function(_0x1a86f7){const _0x1915b5=_0x209d9c,_0x488153=this[_0x1915b5(0x253)]()+_0x1a86f7*this['finalExpRate']();this[_0x1915b5(0x267)](_0x488153,this['shouldDisplayLevelUp']());},Sprite_VictoryGauge[_0x209d9c(0x298)][_0x209d9c(0x25f)]=function(){const _0x268888=_0x209d9c;return SceneManager[_0x268888(0x2ff)]['isVictoryContinueReady']();},Sprite_VictoryGauge['prototype']['updateOpacity']=function(){const _0xffa364=_0x209d9c;this['opacity']=this[_0xffa364(0x2e2)]['contentsOpacity'];},Sprite_VictoryGauge[_0x209d9c(0x298)][_0x209d9c(0x286)]=function(){const _0x14e86f=_0x209d9c;this[_0x14e86f(0x2f8)]['clear'](),this['resetFontSettings'](),this['drawActorName'](),this[_0x14e86f(0x160)](),this[_0x14e86f(0x2e8)](),this[_0x14e86f(0x2a6)](),this[_0x14e86f(0x2c6)]();},Sprite_VictoryGauge['prototype'][_0x209d9c(0x2d1)]=function(){const _0x1c8d10=_0x209d9c;this[_0x1c8d10(0x2f8)][_0x1c8d10(0x1c4)]=$gameSystem['mainFontFace'](),this[_0x1c8d10(0x2f8)][_0x1c8d10(0x2dc)]=$gameSystem[_0x1c8d10(0x191)](),this[_0x1c8d10(0x2f8)][_0x1c8d10(0x2ac)]=ColorManager['normalColor']();},Sprite_VictoryGauge['prototype'][_0x209d9c(0x1e0)]=function(){const _0x18542e=_0x209d9c;this[_0x18542e(0x2d1)]();const _0x971bb=this[_0x18542e(0x172)](),_0x622912=Math[_0x18542e(0x297)](_0x971bb/0x2),_0x41a8d9=0x0,_0x1544dc=this['bitmap'][_0x18542e(0x1a8)]-_0x971bb,_0x6a5e64=_0x18542e(0x21f),_0xe970a4=this[_0x18542e(0x1e5)]()[_0x18542e(0x241)]();this[_0x18542e(0x2f8)][_0x18542e(0x2d9)](_0xe970a4,_0x622912,_0x41a8d9,_0x1544dc,_0x971bb,_0x6a5e64);},Sprite_VictoryGauge[_0x209d9c(0x298)][_0x209d9c(0x160)]=function(){const _0x51bd02=_0x209d9c;this[_0x51bd02(0x2d1)]();const _0x25500e=this[_0x51bd02(0x172)](),_0x19f621=Math['round'](_0x25500e/0x2),_0x17021e=0x0,_0x548987=this[_0x51bd02(0x2f8)][_0x51bd02(0x1a8)]-_0x25500e,_0x2f0902=this[_0x51bd02(0x2d0)]()===''?'right':_0x51bd02(0x248),_0xdb3703=TextManager[_0x51bd02(0x22e)][_0x51bd02(0x1a7)](this[_0x51bd02(0x1e5)]()[_0x51bd02(0x1f0)]);this['_showLevelUp']&&(this[_0x51bd02(0x2f8)][_0x51bd02(0x2ac)]=ColorManager[_0x51bd02(0x148)]()),this['bitmap'][_0x51bd02(0x2d9)](_0xdb3703,_0x19f621,_0x17021e,_0x548987,_0x25500e,_0x2f0902);},Sprite_VictoryGauge[_0x209d9c(0x298)][_0x209d9c(0x2d0)]=function(){const _0x2f1217=_0x209d9c,_0x3de559=$gameParty['members']()[this[_0x2f1217(0x19a)]];if(!_0x3de559)return'';if(Imported['VisuMZ_X_Template']&&VisuMZ[_0x2f1217(0x285)][_0x2f1217(0x20f)][_0x2f1217(0x1b6)]['AftermathActorDisplay'])return VisuMZ['Template']['Settings'][_0x2f1217(0x1b6)]['AftermathText'][_0x2f1217(0x1a7)](_0x3de559[_0x2f1217(0x182)](),TextManager[_0x2f1217(0x28e)],TextManager['jobPointsFull']);if(Imported[_0x2f1217(0x30e)]){const _0x15a1fa=VisuMZ[_0x2f1217(0x167)][_0x2f1217(0x20f)];if(_0x15a1fa[_0x2f1217(0x1bf)]['AftermathActorDisplay'])return _0x15a1fa[_0x2f1217(0x1bf)][_0x2f1217(0x179)][_0x2f1217(0x1a7)](_0x3de559['earnedClassPoints'](),TextManager[_0x2f1217(0x2b6)],TextManager[_0x2f1217(0x27e)]);if(_0x15a1fa[_0x2f1217(0x1b6)][_0x2f1217(0x231)])return _0x15a1fa[_0x2f1217(0x1b6)]['AftermathText'][_0x2f1217(0x1a7)](_0x3de559[_0x2f1217(0x182)](),TextManager[_0x2f1217(0x28e)],TextManager[_0x2f1217(0x1ff)]);}if(Imported[_0x2f1217(0x2ef)]){if('sUZaq'!==_0x2f1217(0x184)){const _0x222d39=this[_0x2f1217(0x172)]()-0x2,_0x46acd8=_0x41f081[_0x2f1217(0x1e2)](_0x222d39/0x2),_0x1ad8cc=_0x2f1217(0x27d),_0x4c25ce=_0x3a3eca[_0x2f1217(0x25e)](),_0x496c33=_0x308a1c-_0x222d39;!_0x27dda6[_0x2f1217(0x2ba)]&&(_0x596681[_0x2f1217(0x2ba)]=new _0x556b17(_0x3635bf,_0x222d39),_0x3ae116[_0x2f1217(0x2ba)]['paintOpacity']=this[_0x2f1217(0x2cd)](),_0x2ee925['victoryNameBitmap'][_0x2f1217(0x211)](_0x46acd8,_0x46acd8,_0x46acd8,_0x1ad8cc),_0x32356b['victoryNameBitmap']['drawCircle'](_0x46acd8+_0x496c33,_0x46acd8,_0x46acd8,_0x1ad8cc),_0x4010a3[_0x2f1217(0x2ba)]['clearRect'](_0x46acd8,0x0,_0x496c33,_0x222d39),_0x510b95['victoryNameBitmap'][_0x2f1217(0x1b8)](_0x46acd8,0x0,_0x496c33,_0x222d39,_0x1ad8cc)),this['contents'][_0x2f1217(0x2f9)](_0xcb8c2c['victoryNameBitmap'],0x0,0x0,_0x1d7e0b,_0x222d39,_0x4d55d2,_0x27686b,_0x3bb1c1,_0x222d39);}else{const _0xfb0ee7=VisuMZ[_0x2f1217(0x14d)][_0x2f1217(0x20f)];if(_0xfb0ee7[_0x2f1217(0x250)][_0x2f1217(0x231)])return _0xfb0ee7['AbilityPoints'][_0x2f1217(0x179)][_0x2f1217(0x1a7)](_0x3de559['earnedAbilityPoints'](),TextManager[_0x2f1217(0x307)],TextManager['abilityPointsFull']);if(_0xfb0ee7[_0x2f1217(0x261)]['AftermathActorDisplay'])return _0x2f1217(0x156)!==_0x2f1217(0x156)?_0xcfe6ee[_0x2f1217(0x250)]['AftermathText']['format'](_0x323306[_0x2f1217(0x284)](),_0x27719b['abilityPointsAbbr'],_0x16565b['abilityPointsFull']):_0xfb0ee7[_0x2f1217(0x261)]['AftermathText'][_0x2f1217(0x1a7)](_0x3de559['earnedSkillPoints'](),TextManager[_0x2f1217(0x155)],TextManager[_0x2f1217(0x14e)]);}}return'';},Sprite_VictoryGauge['prototype'][_0x209d9c(0x2e8)]=function(){const _0x20850b=_0x209d9c;this[_0x20850b(0x2d1)]();const _0x4521b9=this[_0x20850b(0x172)](),_0x3a447d=Math[_0x20850b(0x297)](_0x4521b9/0x2),_0x46c770=0x0,_0xc1d920=this[_0x20850b(0x2f8)][_0x20850b(0x1a8)]-_0x4521b9,_0x264a2d='right';let _0x22368c=this[_0x20850b(0x2d0)]();this[_0x20850b(0x2f8)]['drawText'](_0x22368c,_0x3a447d,_0x46c770,_0xc1d920,_0x4521b9,_0x264a2d);},Sprite_VictoryGauge[_0x209d9c(0x298)][_0x209d9c(0x2a6)]=function(){const _0x2f3b69=_0x209d9c,_0x5d0592=this[_0x2f3b69(0x172)](),_0x40a2d1=this[_0x2f3b69(0x2f8)][_0x2f3b69(0x1a8)]-_0x5d0592,_0x3c1595=Sprite_Gauge['prototype'][_0x2f3b69(0x246)](),_0x4c2a43=Math[_0x2f3b69(0x297)](_0x5d0592/0x2),_0x567cce=_0x5d0592*0x2-_0x3c1595-0x2,_0x40af7d=Math[_0x2f3b69(0x1e2)]((_0x40a2d1-0x2)*this[_0x2f3b69(0x1e5)]()[_0x2f3b69(0x16e)]()),_0x3fc0f0=_0x3c1595-0x2,_0x2849f3=this[_0x2f3b69(0x268)](),_0x12ed0a=this[_0x2f3b69(0x1a1)](),_0x3db6dd=this[_0x2f3b69(0x242)]();this[_0x2f3b69(0x2f8)][_0x2f3b69(0x1b8)](_0x4c2a43,_0x567cce,_0x40a2d1,_0x3c1595,_0x2849f3),this[_0x2f3b69(0x2f8)][_0x2f3b69(0x20a)](_0x4c2a43+0x1,_0x567cce+0x1,_0x40af7d,_0x3fc0f0,_0x12ed0a,_0x3db6dd);},Sprite_VictoryGauge[_0x209d9c(0x298)][_0x209d9c(0x268)]=function(){const _0x599402=_0x209d9c;return ColorManager[_0x599402(0x268)]();},Sprite_VictoryGauge[_0x209d9c(0x298)][_0x209d9c(0x1a1)]=function(){const _0x16b9f2=_0x209d9c;if(this[_0x16b9f2(0x1e5)]()[_0x16b9f2(0x174)]())return Imported[_0x16b9f2(0x2ec)]?ColorManager['maxLvGaugeColor1']():ColorManager[_0x16b9f2(0x2ac)](0xe);else{if('HTYAo'!=='zbBAM')return Imported[_0x16b9f2(0x2ec)]?ColorManager['expGaugeColor1']():ColorManager['textColor'](0x1e);else _0x32031e[_0x16b9f2(0x309)]=new _0x3ffa13(_0x282c43,_0x13866c),_0x33261a['victoryRewardBitmap']['paintOpacity']=this['translucentOpacity'](),_0xb4ebdd['victoryRewardBitmap'][_0x16b9f2(0x211)](_0x455f5b,_0x23db63,_0x444065,_0x41def4),_0x42079f[_0x16b9f2(0x309)]['clearRect'](_0x223885,0x0,_0x5090c1,_0x2ec82f),_0x919811[_0x16b9f2(0x309)][_0x16b9f2(0x1b8)](_0x555dab,0x0,_0x5e2f5b,_0x57acf5,_0xb6938e),_0x160dda[_0x16b9f2(0x309)]['gradientFillRect'](_0x1eea72+_0x494d88,0x0,_0x254f46,_0x3bc262,_0x1011e6,_0xc59379);}},Sprite_VictoryGauge['prototype'][_0x209d9c(0x242)]=function(){const _0x4ef91e=_0x209d9c;return this[_0x4ef91e(0x1e5)]()['isMaxLevel']()?Imported[_0x4ef91e(0x2ec)]?ColorManager[_0x4ef91e(0x20b)]():ColorManager[_0x4ef91e(0x2ac)](0x6):Imported[_0x4ef91e(0x2ec)]?ColorManager[_0x4ef91e(0x294)]():ColorManager[_0x4ef91e(0x2ac)](0x1f);},Sprite_VictoryGauge['prototype'][_0x209d9c(0x2c6)]=function(){const _0x106c2a=_0x209d9c;this['resetFontSettings']();const _0x2e7ab7=this[_0x106c2a(0x172)](),_0x210134=_0x2e7ab7,_0x5df055=_0x2e7ab7;let _0x4d5884=this[_0x106c2a(0x2f8)][_0x106c2a(0x1a8)]-_0x2e7ab7*0x2;const _0x2d97e3=this[_0x106c2a(0x1e5)]();let _0x44bb41=Math[_0x106c2a(0x297)](_0x2d97e3[_0x106c2a(0x253)]()-_0x2d97e3[_0x106c2a(0x272)]()),_0x7526fd='/'+Math['round'](_0x2d97e3[_0x106c2a(0x274)]()-_0x2d97e3[_0x106c2a(0x272)]());Imported[_0x106c2a(0x2ec)]&&VisuMZ[_0x106c2a(0x1f2)]['Settings'][_0x106c2a(0x28d)][_0x106c2a(0x1f6)]&&(_0x44bb41=VisuMZ[_0x106c2a(0x1f5)](_0x44bb41),_0x7526fd=VisuMZ['GroupDigits'](_0x7526fd));this[_0x106c2a(0x25b)]?(this['bitmap'][_0x106c2a(0x2ac)]=ColorManager['victoryLevelUpColor'](),this[_0x106c2a(0x2f8)]['drawText'](TextManager[_0x106c2a(0x219)],_0x210134,_0x5df055,_0x4d5884,_0x2e7ab7,'left')):_0x106c2a(0x2bb)===_0x106c2a(0x2bb)?this[_0x106c2a(0x2f8)][_0x106c2a(0x2d9)](TextManager['exp'],_0x210134,_0x5df055,_0x4d5884,_0x2e7ab7,_0x106c2a(0x21f)):(_0x5d4a93=_0x2ee32e['getInputButtonString']('ok'),_0x5abdc0=_0x1763a8[_0x106c2a(0x311)](_0x106c2a(0x1f8)));this['resetFontSettings']();if(_0x2d97e3[_0x106c2a(0x174)]()){if(_0x106c2a(0x2ea)!==_0x106c2a(0x19f)){this[_0x106c2a(0x2f8)][_0x106c2a(0x2d9)](_0x106c2a(0x271),_0x210134,_0x5df055,_0x4d5884,_0x2e7ab7,'right');return;}else return 0x1;}this[_0x106c2a(0x2f8)][_0x106c2a(0x2dc)]-=0x8,this[_0x106c2a(0x2f8)]['textColor']=ColorManager[_0x106c2a(0x2ac)](0x8),this[_0x106c2a(0x2f8)][_0x106c2a(0x2d9)](_0x7526fd,_0x210134,_0x5df055,_0x4d5884,_0x2e7ab7,'right'),_0x4d5884-=this['bitmap'][_0x106c2a(0x29c)](_0x7526fd),this['resetFontSettings'](),this[_0x106c2a(0x2f8)][_0x106c2a(0x2d9)](_0x44bb41,_0x210134,_0x5df055,_0x4d5884,_0x2e7ab7,'right');};function Window_VictoryContinueMessage(){this['initialize'](...arguments);}Window_VictoryContinueMessage[_0x209d9c(0x298)]=Object['create'](Window_Base[_0x209d9c(0x298)]),Window_VictoryContinueMessage[_0x209d9c(0x298)][_0x209d9c(0x14a)]=Window_VictoryContinueMessage,Window_VictoryContinueMessage['prototype'][_0x209d9c(0x1f3)]=function(_0x32f982){const _0x59a94a=_0x209d9c;Window_Base[_0x59a94a(0x298)][_0x59a94a(0x1f3)][_0x59a94a(0x1ef)](this,_0x32f982),this[_0x59a94a(0x163)](0x2),this[_0x59a94a(0x286)]();},Window_VictoryContinueMessage[_0x209d9c(0x298)][_0x209d9c(0x2f0)]=function(_0x94912){const _0x378551=_0x209d9c;this[_0x378551(0x281)]=_0x94912,this[_0x378551(0x137)]=0x0;},Window_VictoryContinueMessage[_0x209d9c(0x298)]['updatePadding']=function(){const _0x1d5920=_0x209d9c;this[_0x1d5920(0x1f9)]=0x0;},Window_VictoryContinueMessage['prototype']['update']=function(){const _0xf7839a=_0x209d9c;Window_Base['prototype'][_0xf7839a(0x161)][_0xf7839a(0x1ef)](this),this[_0xf7839a(0x1f7)]();},Window_VictoryContinueMessage['prototype'][_0x209d9c(0x1f7)]=function(){const _0x5e983a=_0x209d9c;if(this[_0x5e983a(0x281)]>0x0&&this[_0x5e983a(0x25f)]()){if(_0x5e983a(0x302)!==_0x5e983a(0x255))this[_0x5e983a(0x281)]=0x0,Input[_0x5e983a(0x1c2)](),TouchInput[_0x5e983a(0x1c2)]();else return _0x4fa8b7['SkillPoints'][_0x5e983a(0x179)][_0x5e983a(0x1a7)](_0x156088['earnedSkillPoints'](),_0x4380ff['skillPointsAbbr'],_0x160f45['skillPointsFull']);}if(this[_0x5e983a(0x281)]-->0x0)return;this[_0x5e983a(0x137)]+=Window_VictoryRewards[_0x5e983a(0x1e8)];},Window_VictoryContinueMessage[_0x209d9c(0x298)]['isFastForwarded']=function(){const _0x3108e5=_0x209d9c;return Input[_0x3108e5(0x1df)]('ok')||Input[_0x3108e5(0x1df)](_0x3108e5(0x1f8))||TouchInput['isPressed']();},Window_VictoryContinueMessage[_0x209d9c(0x298)][_0x209d9c(0x286)]=function(){const _0x4f1753=_0x209d9c;this[_0x4f1753(0x1ae)]['clear']();const _0x407820=TextManager[_0x4f1753(0x22a)];let _0x3d3b93=TextManager['victoryKeyOk'],_0x62cb6d=TextManager[_0x4f1753(0x210)];if(Imported[_0x4f1753(0x2ec)]){if(_0x4f1753(0x30c)!==_0x4f1753(0x2bc))_0x3d3b93=TextManager[_0x4f1753(0x311)]('ok'),_0x62cb6d=TextManager['getInputButtonString']('cancel');else{_0x45e2a0['ConvertParams'](_0x3beb8e,_0x446bca);const _0x2c4ec0=_0x56a2a9[_0x4f1753(0x1e5)](_0x1eddc7[_0x4f1753(0x150)]);if(_0x2c4ec0)while(_0x2c4ec0[_0x4f1753(0x233)]()['length']>0x0){_0x2c4ec0['newSkillQuotes']()['shift']();}}}const _0x5d5ce7=_0x407820['format'](_0x3d3b93,_0x62cb6d),_0x4302ad=this['textSizeEx'](_0x5d5ce7)[_0x4f1753(0x1a8)],_0x515391=Math[_0x4f1753(0x297)]((this[_0x4f1753(0x1aa)]-_0x4302ad)/0x2);this[_0x4f1753(0x277)](_0x5d5ce7,_0x515391,0x0,_0x4302ad);},Window_VictoryContinueMessage[_0x209d9c(0x298)][_0x209d9c(0x201)]=function(){const _0x5aa22f=_0x209d9c;return this[_0x5aa22f(0x281)]<=0x0;};function Window_VictoryRewards(){this['initialize'](...arguments);}function _0x47e5(){const _0xd64cb1=['_phase','clear','_subWindow','fontFace','getColorDataFromPluginParameters','isEnabled','_spriteset','victoryDisplayItem','9MzMUss','_drawParamDiff','_actorId','_duration','textSizeEx','abilityPointsFull','_victoryAftermathNewSkillQuotes','_victoryLevelUpSFX','_victoryAftermathCopy','_rewardSets','playVictoryLevelUpSFX','isBattleMember','createBitmap','knUmV','LvUpPan','scale','itemCount','playVictoryMe','victoryLevelUpColor','indexOf','move','createVictoryRewardsWindow','isPressed','drawActorName','_victoryLevelUpWindow','floor','_victoryStep','DrawBackRect','actor','fxyha','2634352CFeLMy','_opacitySpeed','STR','updateOpacity','ZJDpP','right','isVictoryLevelUpPhaseEnabled','ARRAYFUNC','call','level','createVictoryAftermathWindows','CoreEngine','initialize','drawParamBeforeValue','GroupDigits','DigitGroupingStandardText','updateContentsOpacity','cancel','padding','parameters','ARRAYSTR','ZXcTX','processVictoryAftermath','Scene_Battle_update','jobPointsFull','VeCXJ','isContinueReady','faceWidth','BattleManager_isBusy','bossCollapse','ZIKrY','drawParamDiffValue','addChild','_victoryTempActorsA','filter','gradientFillRect','maxLvGaugeColor2','ShowFace','victoryContinueMessageWindowRect','JSON','Settings','victoryKeyCancel','drawCircle','nextVictoryLevelUpActor','LvUpSfx','victoryKeyOk','HideDelayMS','NUM','setupVictoryLevelUpNextActor','initVictoryAftermath','victoryDisplayLvUp','AutoBattleAutoSkip','textWidth','hideWindowsForVictoryAftermath','gainTempExp','randomInt','left','toLowerCase','VisuMZ_1_MainMenuCore','hCXwu','(%1)','drawNewLearnedSkillsBackground','DwSAs','NewQuotes','elODQ','BeUDm','_showBust','victoryContinueFmt','lTfNc','allowUpdateBattleAniSpeed','makeItemGainWindow','victoryDisplayLvFmt','updateExpGain','drawItemName','AftermathActorDisplay','174LGLgpR','newSkillQuotes','lydzV','createVictorySteps','createActorSprite','collapse','BustScale','createVictoryLevelUpWindow','NtrBN','gainRewards','isShowNew','isVictoryContinueReady','_autoBattleVictorySkip','setActionState','endBattle','name','gaugeColor2','processPostBattleCommonEvents','VisuMZ_3_VisualGoldDisplay','ItemScene','gaugeHeight','findNewSkills','center','isCollapsing','1140453sfogKm','parse','drawItemNumber','MessageCore','INXYb','isArmor','AbilityPoints','setup','_victorySteps','currentExp','levelups','AHeqO','activate','bypassVictoryPhase','STRUCT','drawItemDarkRect','victory-level-up-color','_showLevelUp','processVictoryAftermathRewards','WaitBossCollapse','dimColor2','isFastForwarded','Game_Actor_performVictory','SkillPoints','processVictory','ActorQuotesNewSkillClear','quoteLevelSkill','drawActorFace','_additionalSprites','changeExp','gaugeBackColor','setupVictoryAftermathQuotes','_victoryWindows','foMBA','getQuoteWidth','shift','ActorQuotesLevelUpAdd','RGUFU','create','MAX\x20LEVEL','currentLevelExp','fmSvB','nextLevelExp','LvUpColor','SystemBypassVictoryMotion','drawTextEx','toUpperCase','show','version','Game_Actor_setup','ExtDisplayedParams','rgba(0,\x200,\x200,\x201)','classPointsFull','drawRewardStrip','_itemGainWindow','_delayDuration','zVvHy','includes','earnedAbilityPoints','Template','refresh','ContinueFmt','BlEZH','split','_autoBattle','replayBgmAndBgs','push','QoL','jobPointsAbbr','PFoWA','2824743zkftoK','updatePadding','bypassVictoryMusic','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','expGaugeColor2','createVictoryStepLevelUps','playBgm','round','prototype','SystemBypassVictoryMusic','ARRAYSTRUCT','EVAL','measureTextWidth','1315iCLQOL','Game_Actor_shouldDisplayLevelUp','mirrorContents','rgba(0,\x200,\x200,\x200.8)','Data','currencyUnit','createVictoryContinueMessageWindow','BhAsV','BustPosX','drawExpGauge','drawBackgroundElements','skipVictoryAftermathTransition','NewSkill','drawLevelUpQuote','_effectType','textColor','getVictoryAftermathBackColor','drawPartyExpGauges','19957vGbiLD','BlNMk','return\x200','clamp','hERzv','updateVictorySteps','LvUp','classPointsAbbr','_actorSprite','spCGH','victoryNewSkillFmt','victoryNameBitmap','ZIcrS','FjOLZ','drawLevelMessage','Enable','Game_System_initialize','shouldDisplayLevelUp','removeVictoryLevelUpBuffer','_rewards','LvUpVolume','normalColor','MirrorContents','drawExpValues','length','RewardItems','ItemsEquipsCore','finishVictoryPhase','min','sort','translucentOpacity','Game_Actor_isBattleMember','colSpacing','getAdditionalRewardsText','resetFontSettings','quoteLevelUp','items','boxWidth','Rewards','_colorCache','EkvcA','anchor','drawText','playVictoryBgm','_victoryPhase','fontSize','isSceneBattle','(+%1)','ShowParamDiff','trim','Param','_mainWindow','MessageWidth','initMembers','oeIUN','getColor','isBusy','drawActorAdditionalRewards','paramchangeTextColor','CDYPd','ARRAYEVAL','VisuMZ_0_CoreEngine','Bgm','levelUpQuotes','VisuMZ_2_SkillLearnSystem','setDelayDuration','nCdOu','drawNewLearnedSkillsList','pop','isRepeated','paramValueFontSize','iZvIz','status','bitmap','blt','isBypassVictoryAftermathPhase','some','ShowDelayMS','processBattleCoreJS','addChildToBack','_scene','Victory','placeActorGauges','VUrkJ','battleMembers','makeVictoryCopy','hideSubInputWindows','processVictoryAftermathTransition','abilityPointsAbbr','gQmZE','victoryRewardBitmap','victoryAftermathSettings','HideLevelDiff','xUTNa','TOVpH','VisuMZ_2_ClassChangeSystem','volume','updateVictoryPhase','getInputButtonString','maxLvGaugeColor1','General','xtVTY','VictoryAftermath','battlerSprites','KeyOK','processVictoryAftermathMusic','hozmU','ConvertParams','isBypassVictoryAftermathMusic','itemHeight','_currentlevel','changeTextColor','opacity','contentsOpacity','processVictoryAftermathParty','gqEnl','YYFMX','drawParamChanges','Vocab','VisuMZ_1_MessageCore','BustPosY','drawItemBackground','TXJqm','getMenuImage','description','victoryDisplayTitle','drawRewards','processVictoryStep','onVictoryStepLevelUpMember','_victoryUpdateDuration','powerUpColor','drawParamName','constructor','loadPicture','isActor','SkillLearnSystem','skillPointsFull','sWqkQ','ActorID','_victoryLevelUpBuffer','RLQRN','faceHeight','254200mDiiqo','skillPointsAbbr','TRoiA','systemColor','actorParams','makeRewards','_victoryBgm','height','UpdateDuration','CZMwE','maxVisibleItems','ShowBust','drawActorLevel','update','MaxSkills','setBackgroundType','closeCommandWindows','drawNewLearnedSkills','KeyCancel','ClassChangeSystem','index','pitch','VisuMZ_1_OptionsCore','maxBattleMembers','makeTempActors','CDPXX','expRate','LevelUpQuotes','makeDeepCopy','drawItemGainTitle','lineHeight','clearRect','isMaxLevel','_fullWidth','VisuMZ_1_BattleCore','_victoryContinueWindow','loadFaceImages','AftermathText','getQuoteText','LevelUp','ActorQuotesLevelUpClear','_victoryAftermathSettings','itemPadding','createGaugeSprite','Show','LTyRF','earnedJobPoints','map','sUZaq','skills','VisuMZ_1_ItemsEquipsCore','makeFontBigger','victoryFullScreenWindowRect','exp','_victoryTempActorsB','max','exit','setActor','createSubWindow','#%1','beforeActor','mainFontSize','_data','zbswG','BattleManager_initMembers','SystemBypassVictoryPhase','prepareVictoryAftermathTransition','1952792KUFBhH','bypassVictoryMotion','_actor','_index','_showFace','playSe','_victoryActorIndex','registerCommand','YizCn','20728duaKBj','gaugeColor1','concat','_tempActorExpGain','BattleVictoryJS','fZupg','paintOpacity','format','width','bind','innerWidth','param','maxCols','BackRectColor','contents','isBypassVictoryAftermathMotion','performVictory','x%1','drawActorNameStrip','rewards','WaitRegularCollapse','Text','JobPoints','match','fillRect','paramValueByName','Scene_Battle_allowUpdateBattleAniSpeed','_victoryAftermathLevelUpQuotes','rgba(0,\x200,\x200,\x200.4)','checkVictoryAftermathAutoBattleAutoSkip','isVictoryPhase','ClassPoints','drawParamAfterValue'];_0x47e5=function(){return _0xd64cb1;};return _0x47e5();}Window_VictoryRewards['_opacitySpeed']=VisuMZ['VictoryAftermath'][_0x209d9c(0x20f)][_0x209d9c(0x313)]['FadeInSpeed'],Window_VictoryRewards[_0x209d9c(0x298)]=Object['create'](Window_StatusBase[_0x209d9c(0x298)]),Window_VictoryRewards[_0x209d9c(0x298)][_0x209d9c(0x14a)]=Window_VictoryRewards,Window_VictoryRewards[_0x209d9c(0x298)]['initialize']=function(_0x1fce48){const _0xe3ba85=_0x209d9c;Window_StatusBase[_0xe3ba85(0x298)]['initialize'][_0xe3ba85(0x1ef)](this,_0x1fce48),this[_0xe3ba85(0x163)](0x2),this[_0xe3ba85(0x137)]=0x0,this['refresh']();},Window_VictoryRewards['prototype'][_0x209d9c(0x291)]=function(){this['padding']=0x0;},Window_VictoryRewards[_0x209d9c(0x298)][_0x209d9c(0x161)]=function(){const _0x26ae24=_0x209d9c;Window_StatusBase[_0x26ae24(0x298)][_0x26ae24(0x161)][_0x26ae24(0x1ef)](this),this[_0x26ae24(0x1f7)]();},Window_VictoryRewards[_0x209d9c(0x298)][_0x209d9c(0x1f7)]=function(){const _0x285f59=_0x209d9c;SceneManager['_scene'][_0x285f59(0x1e3)]===_0x285f59(0x1b3)?this[_0x285f59(0x137)]+=Window_VictoryRewards[_0x285f59(0x1e8)]:this[_0x285f59(0x137)]-=Window_VictoryRewards[_0x285f59(0x1e8)];},Window_VictoryRewards[_0x209d9c(0x298)]['mirrorContents']=function(){const _0x9adb21=_0x209d9c;return VisuMZ[_0x9adb21(0x315)][_0x9adb21(0x20f)][_0x9adb21(0x313)][_0x9adb21(0x2c5)];},Window_VictoryRewards[_0x209d9c(0x298)][_0x209d9c(0x286)]=function(){const _0x201a30=_0x209d9c;Window_StatusBase[_0x201a30(0x298)][_0x201a30(0x286)][_0x201a30(0x1ef)](this),this[_0x201a30(0x1ae)][_0x201a30(0x1c2)](),this['resetFontSettings'](),this['drawBackgroundElements'](),this[_0x201a30(0x144)](),this[_0x201a30(0x171)](),this['makeItemGainWindow'](),this[_0x201a30(0x2ae)]();},Window_VictoryRewards[_0x209d9c(0x298)][_0x209d9c(0x2a7)]=function(){const _0x26f206=_0x209d9c,_0x10b845=this[_0x26f206(0x172)](),_0x568c71=0x0,_0x4aca3d=_0x10b845*2.5,_0xf31d33=_0x26f206(0x2a0),_0x3a21ef=_0x26f206(0x1bc),_0x58d31c=ColorManager['normalColor']();this[_0x26f206(0x1ae)]['gradientFillRect'](_0x568c71,_0x4aca3d,this[_0x26f206(0x1a8)],this[_0x26f206(0x15b)]-_0x4aca3d-_0x10b845*1.5,_0xf31d33,_0x3a21ef),this['contents'][_0x26f206(0x1b8)](0x0,_0x4aca3d-0x1,this[_0x26f206(0x1a8)],0x2,_0x58d31c),this[_0x26f206(0x1ae)][_0x26f206(0x1b8)](0x0,this[_0x26f206(0x15b)]-_0x10b845*1.5-0x1,this['width'],0x2,_0x58d31c);const _0x3f6708=this[_0x26f206(0x29f)](),_0x4ca6bc=_0x3f6708?Math['round'](this[_0x26f206(0x1a8)]/0x2+0x28):0x64,_0x209fea=_0x4aca3d-_0x10b845*0.75,_0x2f3257=TextManager[_0x26f206(0x143)];this[_0x26f206(0x187)](),this[_0x26f206(0x187)](),this['drawText'](_0x2f3257,_0x4ca6bc,_0x209fea,this[_0x26f206(0x1a8)]);},Window_VictoryRewards[_0x209d9c(0x1d2)]=VisuMZ[_0x209d9c(0x315)]['Settings'][_0x209d9c(0x2d5)],Window_VictoryRewards[_0x209d9c(0x298)][_0x209d9c(0x144)]=function(){const _0x307e74=_0x209d9c;this[_0x307e74(0x2d1)]();const _0x1f2b6f=this[_0x307e74(0x29f)](),_0x58b6eb=this['lineHeight'](),_0x94971a=Math['floor'](_0x58b6eb/0x2),_0x4b0478=_0x1f2b6f?Math['round'](this[_0x307e74(0x1a8)]/0x2+0x28):0x64,_0x350062=Math[_0x307e74(0x297)](_0x58b6eb*3.5),_0x21723a=Math[_0x307e74(0x297)](this['width']/0x2-0x8c),_0x35f4d7=_0x21723a-_0x94971a-0x50;let _0x962207=_0x350062;for(const _0x5199c9 of Window_VictoryRewards[_0x307e74(0x1d2)]){if(!_0x5199c9[_0x307e74(0x180)]())continue;this[_0x307e74(0x27f)](_0x4b0478,_0x962207,_0x21723a),this['changeTextColor'](ColorManager[_0x307e74(0x157)]()),this[_0x307e74(0x2d9)](_0x5199c9[_0x307e74(0x1b5)](),_0x4b0478+_0x94971a,_0x962207,_0x35f4d7),this['changeTextColor'](ColorManager['normalColor']());const _0x17b900=_0x5199c9[_0x307e74(0x2a1)]();if(Imported[_0x307e74(0x244)]&&_0x5199c9['Text']()===TextManager[_0x307e74(0x2a2)])this['drawCurrencyValue'](_0x17b900,TextManager['currencyUnit'],_0x4b0478+_0x94971a,_0x962207,_0x35f4d7);else{if(_0x307e74(0x23a)!==_0x307e74(0x23a))return _0x363eb3[_0x307e74(0x2c2)]['items'][_0x307e74(0x209)](_0x9aa466=>_0x9aa466===_0x48790a)['length'];else this[_0x307e74(0x2d9)](_0x17b900,_0x4b0478+_0x94971a,_0x962207,_0x35f4d7,_0x307e74(0x1ec));}_0x962207+=_0x58b6eb;}},Window_VictoryRewards[_0x209d9c(0x298)]['drawRewardStrip']=function(_0x3fb703,_0x34acf0,_0x57c3d8){const _0x3ec06e=_0x209d9c,_0x556109=this[_0x3ec06e(0x172)]()-0x2,_0x4e09cb=Math['floor'](_0x556109/0x2),_0x5522bc=_0x3ec06e(0x27d),_0x26b930=ColorManager[_0x3ec06e(0x25e)](),_0x1a7d0b=0x50,_0x5ccbc7=_0x57c3d8-_0x4e09cb-_0x1a7d0b;!ImageManager[_0x3ec06e(0x309)]&&(ImageManager[_0x3ec06e(0x309)]=new Bitmap(_0x57c3d8,_0x556109),ImageManager['victoryRewardBitmap'][_0x3ec06e(0x1a6)]=this['translucentOpacity'](),ImageManager['victoryRewardBitmap']['drawCircle'](_0x4e09cb,_0x4e09cb,_0x4e09cb,_0x5522bc),ImageManager[_0x3ec06e(0x309)][_0x3ec06e(0x173)](_0x4e09cb,0x0,_0x556109,_0x556109),ImageManager['victoryRewardBitmap']['fillRect'](_0x4e09cb,0x0,_0x5ccbc7,_0x556109,_0x5522bc),ImageManager[_0x3ec06e(0x309)]['gradientFillRect'](_0x4e09cb+_0x5ccbc7,0x0,_0x1a7d0b,_0x556109,_0x5522bc,_0x26b930)),this['contents']['blt'](ImageManager[_0x3ec06e(0x309)],0x0,0x0,_0x57c3d8,_0x556109,_0x3fb703,_0x34acf0,_0x57c3d8,_0x556109);},Window_VictoryRewards[_0x209d9c(0x298)]['drawItemGainTitle']=function(){const _0x1e5aa6=_0x209d9c;this[_0x1e5aa6(0x2d1)]();if(BattleManager['_rewards'][_0x1e5aa6(0x2d3)][_0x1e5aa6(0x2c7)]<=0x0)return;const _0x5dd7be=this[_0x1e5aa6(0x29f)](),_0x423448=this[_0x1e5aa6(0x172)](),_0x1e6e4e=_0x5dd7be?0x8c:Math[_0x1e5aa6(0x297)](this[_0x1e5aa6(0x1a8)]/0x2+0x28),_0x18c307=Math[_0x1e5aa6(0x297)](_0x423448*0x3),_0x50163b=Math[_0x1e5aa6(0x297)](this['width']/0x2-0x8c),_0x18bfb2=TextManager[_0x1e5aa6(0x1c8)],_0x1e9230=ColorManager['normalColor']();this['makeFontBigger'](),this[_0x1e5aa6(0x2d9)](_0x18bfb2,_0x1e6e4e,_0x18c307,_0x50163b,_0x1e5aa6(0x21f));const _0x1c520b=_0x5dd7be?0x64:Math[_0x1e5aa6(0x297)](this[_0x1e5aa6(0x1a8)]/0x2),_0x413d08=_0x18c307+_0x423448*1.5,_0x15c0a6=Math[_0x1e5aa6(0x297)](this[_0x1e5aa6(0x1a8)]/0x2)-0x64;this[_0x1e5aa6(0x1ae)][_0x1e5aa6(0x1b8)](_0x1c520b,_0x413d08,_0x15c0a6,0x2,_0x1e9230);},Window_VictoryRewards['prototype'][_0x209d9c(0x22d)]=function(){const _0x5a094e=_0x209d9c,_0x1188fd=this['mirrorContents'](),_0x63cf8e=this[_0x5a094e(0x172)](),_0x525f69=_0x1188fd?0x64:Math[_0x5a094e(0x297)](this[_0x5a094e(0x1a8)]/0x2+0x28),_0x5114f6=Math[_0x5a094e(0x297)](_0x63cf8e*0x5),_0x545837=Math['round'](this[_0x5a094e(0x1a8)]/0x2-0x8c),_0x1ded54=this[_0x5a094e(0x15b)]-_0x5114f6-_0x63cf8e*0x2,_0x2a791d=new Rectangle(_0x525f69,_0x5114f6,_0x545837,_0x1ded54);this[_0x5a094e(0x280)]=new Window_VictoryItem(_0x2a791d,this),this[_0x5a094e(0x207)](this[_0x5a094e(0x280)]);},Window_VictoryRewards[_0x209d9c(0x298)][_0x209d9c(0x2ae)]=function(){const _0x53d9c7=_0x209d9c;this[_0x53d9c7(0x2d1)]();const _0x53e184=this[_0x53d9c7(0x29f)](),_0x1f7e50=this[_0x53d9c7(0x172)](),_0x27929c=$gameParty['maxBattleMembers'](),_0x3c5b66=_0x53e184?Math[_0x53d9c7(0x297)](this['width']/0x2+0x28):0x64,_0x480563=this[_0x53d9c7(0x15b)]-1.5-_0x1f7e50*0x2*(_0x27929c+0x1),_0x7088c2=Math['round'](this[_0x53d9c7(0x1a8)]/0x2-0x8c);let _0x1231b5=_0x480563;if(VisuMZ[_0x53d9c7(0x315)][_0x53d9c7(0x20f)]['General']['ShowExpGauges']??!![])for(let _0x40e439=0x0;_0x40e439<_0x27929c;_0x40e439++){if(!$gameParty['members']()[_0x40e439])continue;this['drawActorNameStrip'](_0x3c5b66,_0x1231b5,_0x7088c2),this[_0x53d9c7(0x301)](_0x40e439,_0x3c5b66,_0x1231b5,_0x7088c2),_0x1231b5+=_0x1f7e50*0x2;}},Window_VictoryRewards[_0x209d9c(0x298)][_0x209d9c(0x1b2)]=function(_0x1ff53e,_0x4aadbf,_0x554f74){const _0x7bc33e=_0x209d9c,_0x3f27f9=this[_0x7bc33e(0x172)]()-0x2,_0x18bc55=Math[_0x7bc33e(0x1e2)](_0x3f27f9/0x2),_0x2e5d11='rgba(0,\x200,\x200,\x201)',_0x5cdf50=ColorManager[_0x7bc33e(0x25e)](),_0x239a20=_0x554f74-_0x3f27f9;!ImageManager['victoryNameBitmap']&&(ImageManager[_0x7bc33e(0x2ba)]=new Bitmap(_0x554f74,_0x3f27f9),ImageManager[_0x7bc33e(0x2ba)][_0x7bc33e(0x1a6)]=this['translucentOpacity'](),ImageManager[_0x7bc33e(0x2ba)][_0x7bc33e(0x211)](_0x18bc55,_0x18bc55,_0x18bc55,_0x2e5d11),ImageManager[_0x7bc33e(0x2ba)]['drawCircle'](_0x18bc55+_0x239a20,_0x18bc55,_0x18bc55,_0x2e5d11),ImageManager['victoryNameBitmap'][_0x7bc33e(0x173)](_0x18bc55,0x0,_0x239a20,_0x3f27f9),ImageManager['victoryNameBitmap'][_0x7bc33e(0x1b8)](_0x18bc55,0x0,_0x239a20,_0x3f27f9,_0x2e5d11)),this['contents']['blt'](ImageManager['victoryNameBitmap'],0x0,0x0,_0x554f74,_0x3f27f9,_0x1ff53e,_0x4aadbf,_0x554f74,_0x3f27f9);},Window_VictoryRewards[_0x209d9c(0x298)][_0x209d9c(0x301)]=function(_0x2eb511,_0x51535a,_0x3f59ae,_0x233313){const _0x3c6aa6=_0x209d9c,_0x31acda='actor%1-gauge'[_0x3c6aa6(0x1a7)](_0x2eb511),_0x44ab60=this[_0x3c6aa6(0x17f)](_0x31acda,_0x2eb511,_0x233313);_0x44ab60[_0x3c6aa6(0x1dd)](_0x51535a,_0x3f59ae),_0x44ab60[_0x3c6aa6(0x279)]();},Window_VictoryRewards[_0x209d9c(0x298)][_0x209d9c(0x17f)]=function(_0x5b8533,_0x5b567f,_0x200248){const _0x16f318=_0x209d9c,_0xcccccd=this[_0x16f318(0x266)];if(_0xcccccd[_0x5b8533]){if(_0x16f318(0x2f6)===_0x16f318(0x2f6))return _0xcccccd[_0x5b8533];else{this[_0x16f318(0x135)](_0x45af49[_0x16f318(0x157)]());let _0x4f298f='';_0x311cfb===_0x16f318(0x1f0)?_0x4f298f=_0x5d49c2['level']:_0x4f298f=_0x566a0d[_0x16f318(0x1ab)](_0x1883f5),this[_0x16f318(0x2d9)](_0x4f298f,_0x1e5e5d+this[_0x16f318(0x17e)](),_0x5b9966,_0x2cf6fe-this[_0x16f318(0x17e)]()*0x2);}}else{if('KlxKk'==='quOSp')_0x4df399[_0x16f318(0x315)]['Game_Actor_performVictory'][_0x16f318(0x1ef)](this);else{const _0x4f413d=new Sprite_VictoryGauge(_0x5b567f,this,_0x200248);return _0xcccccd[_0x5b8533]=_0x4f413d,this['addInnerChild'](_0x4f413d),_0x4f413d;}}};function _0xc460(_0x238a3b,_0x284200){const _0x47e545=_0x47e5();return _0xc460=function(_0xc4606f,_0x509893){_0xc4606f=_0xc4606f-0x12f;let _0x59a1e3=_0x47e545[_0xc4606f];return _0x59a1e3;},_0xc460(_0x238a3b,_0x284200);}function Window_VictoryItem(){const _0x56cf26=_0x209d9c;this[_0x56cf26(0x1f3)](...arguments);}Window_VictoryItem[_0x209d9c(0x298)]=Object[_0x209d9c(0x270)](Window_ItemList[_0x209d9c(0x298)]),Window_VictoryItem[_0x209d9c(0x298)][_0x209d9c(0x14a)]=Window_VictoryItem,Window_VictoryItem[_0x209d9c(0x298)][_0x209d9c(0x1f3)]=function(_0xcd6251,_0x3ee3f9){const _0x2f73a3=_0x209d9c;this[_0x2f73a3(0x2e2)]=_0x3ee3f9,Window_ItemList[_0x2f73a3(0x298)][_0x2f73a3(0x1f3)][_0x2f73a3(0x1ef)](this,_0xcd6251),this['setBackgroundType'](0x2),this[_0x2f73a3(0x286)](),this['updateContentsOpacity'](),this[_0x2f73a3(0x192)][_0x2f73a3(0x2c7)]>this[_0x2f73a3(0x15e)]()&&(_0x2f73a3(0x228)!==_0x2f73a3(0x15d)?(this[_0x2f73a3(0x256)](),this['select'](0x0)):(this[_0x2f73a3(0x1bd)](),this[_0x2f73a3(0x240)](0x0),this[_0x2f73a3(0x2db)]=!![],this[_0x2f73a3(0x2fa)]()?this[_0x2f73a3(0x2a8)]():this[_0x2f73a3(0x306)]()));},Window_VictoryItem[_0x209d9c(0x298)][_0x209d9c(0x133)]=function(){const _0x90f3e2=_0x209d9c;return Window_Base['prototype']['itemHeight'][_0x90f3e2(0x1ef)](this);},Window_VictoryItem[_0x209d9c(0x298)]['updatePadding']=function(){this['padding']=0x0;},Window_VictoryItem['prototype'][_0x209d9c(0x1ac)]=function(){return 0x1;},Window_VictoryItem['prototype'][_0x209d9c(0x2cf)]=function(){return 0x0;},Window_VictoryItem['prototype']['update']=function(){const _0x40effa=_0x209d9c;Window_ItemList[_0x40effa(0x298)][_0x40effa(0x161)][_0x40effa(0x1ef)](this),this['updateContentsOpacity']();},Window_VictoryItem[_0x209d9c(0x298)]['updateContentsOpacity']=function(){const _0x5a2d5b=_0x209d9c;this['contentsOpacity']=this[_0x5a2d5b(0x2e2)][_0x5a2d5b(0x137)];},Window_VictoryItem[_0x209d9c(0x298)]['makeItemList']=function(){const _0x44dfad=_0x209d9c,_0x503461=BattleManager[_0x44dfad(0x2c2)]['items'];_0x503461[_0x44dfad(0x2cc)]((_0x2c496f,_0xf38e5b)=>_0x2c496f['id']-_0xf38e5b['id']);const _0x33a8df=_0x503461[_0x44dfad(0x209)](_0xadb28a=>DataManager['isItem'](_0xadb28a)),_0x1f9441=_0x503461['filter'](_0x3535f6=>DataManager['isWeapon'](_0x3535f6)),_0x3fb05a=_0x503461[_0x44dfad(0x209)](_0xcb8e1d=>DataManager[_0x44dfad(0x24f)](_0xcb8e1d));this['_data']=_0x33a8df[_0x44dfad(0x1a2)](_0x1f9441)[_0x44dfad(0x1a2)](_0x3fb05a),this[_0x44dfad(0x192)]=this[_0x44dfad(0x192)][_0x44dfad(0x209)]((_0x26b012,_0x2ed95f,_0x392b22)=>_0x392b22[_0x44dfad(0x1dc)](_0x26b012)===_0x2ed95f);},Window_VictoryItem[_0x209d9c(0x298)][_0x209d9c(0x1c6)]=function(_0x49583c){return!![];},Window_VictoryItem[_0x209d9c(0x298)][_0x209d9c(0x23c)]=function(){return![];},Window_VictoryItem[_0x209d9c(0x298)][_0x209d9c(0x1d9)]=function(_0x258bf4){const _0x15c5d7=_0x209d9c;return BattleManager[_0x15c5d7(0x2c2)]['items'][_0x15c5d7(0x209)](_0x2fb9f9=>_0x2fb9f9===_0x258bf4)[_0x15c5d7(0x2c7)];},Window_VictoryItem[_0x209d9c(0x298)][_0x209d9c(0x13f)]=function(_0x57b796){},Window_VictoryItem[_0x209d9c(0x298)][_0x209d9c(0x24c)]=function(_0x14dae5,_0x39440d,_0x5561a5,_0x1ba9e3){const _0x274f31=_0x209d9c;let _0x3c6dcc=_0x274f31(0x1b1);Imported[_0x274f31(0x186)]&&(_0x3c6dcc=VisuMZ['ItemsEquipsCore'][_0x274f31(0x20f)][_0x274f31(0x245)]['ItemQuantityFmt']);let _0x7e2178=_0x3c6dcc['format'](this[_0x274f31(0x1d9)](_0x14dae5));this[_0x274f31(0x2d9)](_0x7e2178,_0x39440d,_0x5561a5,_0x1ba9e3,_0x274f31(0x1ec));};function Window_VictoryLevelUp(){const _0x3e05c6=_0x209d9c;this[_0x3e05c6(0x1f3)](...arguments);}Window_VictoryLevelUp[_0x209d9c(0x1e8)]=Window_VictoryRewards[_0x209d9c(0x1e8)],Window_VictoryLevelUp[_0x209d9c(0x229)]=VisuMZ[_0x209d9c(0x315)][_0x209d9c(0x20f)]['LevelUp'][_0x209d9c(0x15f)],Window_VictoryLevelUp['prototype']=Object[_0x209d9c(0x270)](Window_StatusBase[_0x209d9c(0x298)]),Window_VictoryLevelUp['prototype']['constructor']=Window_VictoryLevelUp,Window_VictoryLevelUp[_0x209d9c(0x298)][_0x209d9c(0x1f3)]=function(_0x3af7d0){const _0x535d8e=_0x209d9c;Window_StatusBase[_0x535d8e(0x298)][_0x535d8e(0x1f3)][_0x535d8e(0x1ef)](this,_0x3af7d0),this[_0x535d8e(0x163)](0x2),this['contentsOpacity']=0x0,this[_0x535d8e(0x286)](),this['createActorSprite'](),this[_0x535d8e(0x18e)]();},Window_VictoryLevelUp[_0x209d9c(0x298)]['updatePadding']=function(){const _0x2b9db4=_0x209d9c;this[_0x2b9db4(0x1f9)]=0x0;},Window_VictoryLevelUp['prototype']['update']=function(){const _0x4ead5f=_0x209d9c;Window_StatusBase[_0x4ead5f(0x298)][_0x4ead5f(0x161)][_0x4ead5f(0x1ef)](this),this[_0x4ead5f(0x1f7)]();},Window_VictoryLevelUp['prototype']['updateContentsOpacity']=function(){const _0x48aa27=_0x209d9c;if(SceneManager['_scene'][_0x48aa27(0x1e3)]===_0x48aa27(0x254))this[_0x48aa27(0x137)]+=Window_VictoryLevelUp['_opacitySpeed'];else{if(_0x48aa27(0x2b3)==='TzUnk')return![];else this[_0x48aa27(0x137)]-=Window_VictoryLevelUp['_opacitySpeed'];}if(this[_0x48aa27(0x2b7)]){if(_0x48aa27(0x16d)===_0x48aa27(0x16d))this[_0x48aa27(0x2b7)][_0x48aa27(0x136)]=this[_0x48aa27(0x137)];else{const _0x356e49=_0x4426f0['VictoryAftermath']['Settings'][_0x48aa27(0x313)],_0x424fad=_0x4c1698[_0x48aa27(0x2ff)];this[_0x48aa27(0x1a3)]=this[_0x48aa27(0x2c2)][_0x48aa27(0x189)]/(_0x335008['_victoryUpdateDuration']||0x1),_0x5509d7[_0x48aa27(0x298)]['loadFaceImages'](),_0x390a7e(_0x424fad[_0x48aa27(0x21c)][_0x48aa27(0x1a9)](_0x424fad),_0x356e49[_0x48aa27(0x215)]),_0x117c13(_0x424fad['createVictoryAftermathWindows']['bind'](_0x424fad),_0x356e49[_0x48aa27(0x2fc)]);}}},Window_VictoryLevelUp[_0x209d9c(0x298)]['refresh']=function(){const _0x18d4a3=_0x209d9c;Window_StatusBase[_0x18d4a3(0x298)]['refresh'][_0x18d4a3(0x1ef)](this),this[_0x18d4a3(0x1ae)][_0x18d4a3(0x1c2)](),this[_0x18d4a3(0x2d1)](),this[_0x18d4a3(0x2a7)]();},Window_VictoryLevelUp[_0x209d9c(0x298)]['drawBackgroundElements']=function(){const _0x210ff0=_0x209d9c,_0x5b5cb0=this[_0x210ff0(0x172)](),_0x2c0adb='rgba(0,\x200,\x200,\x200.8)',_0x5a4839='rgba(0,\x200,\x200,\x200.4)',_0x405c61=ColorManager[_0x210ff0(0x2c4)](),_0x5d476a=SceneManager[_0x210ff0(0x2ff)][_0x210ff0(0x177)]['x'],_0x12f69d=Math[_0x210ff0(0x297)](this['width']/0x2);this[_0x210ff0(0x1ae)][_0x210ff0(0x20a)](_0x5d476a,0x0,_0x12f69d,this[_0x210ff0(0x15b)],_0x5a4839,_0x2c0adb,!![]),this['contents'][_0x210ff0(0x1b8)](_0x5d476a-0x1,0x0,0x2,this[_0x210ff0(0x15b)],_0x405c61),this[_0x210ff0(0x1ae)][_0x210ff0(0x1b8)](_0x5d476a+_0x12f69d-0x1,0x0,0x2,this['height'],_0x405c61);const _0x1f78f4=_0x5b5cb0,_0x135b1c=_0x5b5cb0*0x1;this[_0x210ff0(0x1ae)]['gradientFillRect'](0x0,_0x1f78f4,this[_0x210ff0(0x1a8)],_0x135b1c,_0x2c0adb,_0x5a4839),this[_0x210ff0(0x1ae)][_0x210ff0(0x1b8)](0x0,_0x1f78f4-0x1,this['width'],0x2,_0x405c61),this['contents'][_0x210ff0(0x1b8)](0x0,_0x1f78f4+_0x135b1c-0x1,this[_0x210ff0(0x1a8)],0x2,_0x405c61);const _0x13799d=this[_0x210ff0(0x15b)]-_0x5b5cb0*5.5,_0x52e400=_0x5b5cb0*0x4;this[_0x210ff0(0x1ae)][_0x210ff0(0x20a)](0x0,_0x13799d,this[_0x210ff0(0x1a8)],_0x52e400,_0x2c0adb,_0x5a4839),this[_0x210ff0(0x1ae)]['gradientFillRect'](0x0,_0x13799d,this[_0x210ff0(0x1a8)],_0x52e400,_0x5a4839,_0x2c0adb),this[_0x210ff0(0x1ae)][_0x210ff0(0x1b8)](0x0,_0x13799d-0x2,this[_0x210ff0(0x1a8)],0x2,_0x405c61),this['contents']['fillRect'](0x0,_0x13799d+_0x52e400,this[_0x210ff0(0x1a8)],0x2,_0x405c61);},Window_VictoryLevelUp[_0x209d9c(0x298)][_0x209d9c(0x236)]=function(){const _0x31ec4e=_0x209d9c,_0x28e7cc=VisuMZ[_0x31ec4e(0x315)][_0x31ec4e(0x20f)][_0x31ec4e(0x17b)];this[_0x31ec4e(0x2b7)]=new Sprite(),this['_actorSprite'][_0x31ec4e(0x2d8)]['x']=0.5,this[_0x31ec4e(0x2b7)][_0x31ec4e(0x2d8)]['y']=0x1,this[_0x31ec4e(0x2b7)]['opacity']=0x0,this[_0x31ec4e(0x2b7)]['x']=Math[_0x31ec4e(0x297)](eval(_0x28e7cc[_0x31ec4e(0x2a5)])),this[_0x31ec4e(0x2b7)]['y']=Math[_0x31ec4e(0x297)](eval(_0x28e7cc[_0x31ec4e(0x13e)])),this[_0x31ec4e(0x2b7)][_0x31ec4e(0x1d8)]['x']=_0x28e7cc[_0x31ec4e(0x238)],this[_0x31ec4e(0x2b7)]['scale']['y']=_0x28e7cc[_0x31ec4e(0x238)],this[_0x31ec4e(0x2fe)](this['_actorSprite']);},Window_VictoryLevelUp[_0x209d9c(0x298)][_0x209d9c(0x18e)]=function(){const _0x2340f9=_0x209d9c,_0x3ccd51=new Rectangle(0x0,0x0,this['width'],this[_0x2340f9(0x15b)]);this[_0x2340f9(0x1c3)]=new Window_VictoryLevelUpActor(_0x3ccd51,this),this[_0x2340f9(0x207)](this[_0x2340f9(0x1c3)]);},Window_VictoryLevelUp[_0x209d9c(0x298)][_0x209d9c(0x18d)]=function(_0x26f2b0){const _0x16b60b=_0x209d9c;Imported['VisuMZ_1_MainMenuCore']&&Window_VictoryLevelUp[_0x16b60b(0x229)]&&(this[_0x16b60b(0x2b7)][_0x16b60b(0x2f8)]=ImageManager[_0x16b60b(0x14b)](_0x26f2b0[_0x16b60b(0x141)]())),SoundManager['playVictoryLevelUpSFX'](),this[_0x16b60b(0x1c3)]['setActor'](_0x26f2b0);};function Window_VictoryLevelUpActor(){const _0x38de54=_0x209d9c;this[_0x38de54(0x1f3)](...arguments);}Window_VictoryLevelUpActor[_0x209d9c(0x1e8)]=Window_VictoryRewards['_opacitySpeed'],Window_VictoryLevelUpActor['_drawParamDiff']=VisuMZ['VictoryAftermath'][_0x209d9c(0x20f)][_0x209d9c(0x17b)][_0x209d9c(0x2df)],Window_VictoryLevelUpActor[_0x209d9c(0x19b)]=VisuMZ[_0x209d9c(0x315)][_0x209d9c(0x20f)]['LevelUp'][_0x209d9c(0x20c)],Window_VictoryLevelUpActor[_0x209d9c(0x298)]=Object['create'](Window_StatusBase[_0x209d9c(0x298)]),Window_VictoryLevelUpActor['prototype'][_0x209d9c(0x14a)]=Window_VictoryLevelUpActor,Window_VictoryLevelUpActor[_0x209d9c(0x298)][_0x209d9c(0x1f3)]=function(_0x536316,_0x4fa798){const _0x4577aa=_0x209d9c;this[_0x4577aa(0x2e2)]=_0x4fa798,Window_StatusBase[_0x4577aa(0x298)][_0x4577aa(0x1f3)][_0x4577aa(0x1ef)](this,_0x536316),this[_0x4577aa(0x163)](0x2),this[_0x4577aa(0x137)]=0x0,this[_0x4577aa(0x199)]=null,this[_0x4577aa(0x286)]();},Window_VictoryLevelUpActor[_0x209d9c(0x298)][_0x209d9c(0x291)]=function(){this['padding']=0x0;},Window_VictoryLevelUpActor[_0x209d9c(0x298)][_0x209d9c(0x161)]=function(){const _0x1d4634=_0x209d9c;Window_StatusBase['prototype']['update'][_0x1d4634(0x1ef)](this),this[_0x1d4634(0x1f7)]();},Window_VictoryLevelUpActor[_0x209d9c(0x298)][_0x209d9c(0x1f7)]=function(){const _0xcf1e63=_0x209d9c;this['contentsOpacity']=this[_0xcf1e63(0x2e2)][_0xcf1e63(0x137)];},Window_VictoryLevelUpActor['prototype'][_0x209d9c(0x18d)]=function(_0x378bdf){const _0x1078cc=_0x209d9c;this[_0x1078cc(0x199)]=_0x378bdf,this[_0x1078cc(0x286)]();},Window_VictoryLevelUpActor['prototype'][_0x209d9c(0x190)]=function(){const _0x20e908=_0x209d9c,_0x268fcc=this[_0x20e908(0x199)]['index']();return BattleManager[_0x20e908(0x18a)][_0x268fcc];},Window_VictoryLevelUpActor[_0x209d9c(0x298)]['afterActor']=function(){const _0x149ab4=_0x209d9c,_0x14b78b=this[_0x149ab4(0x199)][_0x149ab4(0x168)]();return BattleManager[_0x149ab4(0x208)][_0x14b78b];},Window_VictoryLevelUpActor[_0x209d9c(0x298)][_0x209d9c(0x286)]=function(){const _0x2b41f3=_0x209d9c;Window_StatusBase[_0x2b41f3(0x298)][_0x2b41f3(0x286)]['call'](this),this[_0x2b41f3(0x1ae)][_0x2b41f3(0x1c2)](),this[_0x2b41f3(0x2d1)]();if(!this[_0x2b41f3(0x199)])return;this[_0x2b41f3(0x2bd)](),this[_0x2b41f3(0x13b)](),this[_0x2b41f3(0x165)](),this[_0x2b41f3(0x2aa)]();},Window_VictoryLevelUpActor['prototype']['drawLevelMessage']=function(){const _0xdd0027=_0x209d9c,_0x4a4e81=this['lineHeight'](),_0x5b507d=TextManager['levelUp'][_0xdd0027(0x1a7)](this[_0xdd0027(0x199)][_0xdd0027(0x241)](),TextManager[_0xdd0027(0x1f0)],this[_0xdd0027(0x199)][_0xdd0027(0x1f0)]),_0x49d6f2=this[_0xdd0027(0x1cd)](_0x5b507d)[_0xdd0027(0x1a8)],_0x303502=SceneManager[_0xdd0027(0x2ff)][_0xdd0027(0x177)]['x']+Math[_0xdd0027(0x297)]((this[_0xdd0027(0x1a8)]/0x2-_0x49d6f2)/0x2),_0x2c60ff=_0x4a4e81;this['drawTextEx'](_0x5b507d,_0x303502,_0x2c60ff,_0x49d6f2);},Window_VictoryLevelUpActor[_0x209d9c(0x298)]['drawItemDarkRect']=function(_0x16a742,_0x36fcda,_0x5babee,_0x51ef45,_0x3bcda7){const _0x1da8f1=_0x209d9c;if(VisuMZ[_0x1da8f1(0x315)][_0x1da8f1(0x20f)][_0x1da8f1(0x17b)][_0x1da8f1(0x1e4)]===![])return;_0x3bcda7=Math[_0x1da8f1(0x18b)](_0x3bcda7||0x1,0x1);while(_0x3bcda7--){if('DwSAs'!==_0x1da8f1(0x225))_0x25117f=_0x299424[_0x1da8f1(0x1f0)],_0x15fcf3=_0x3bbcd9[_0x1da8f1(0x1f0)];else{_0x51ef45=_0x51ef45||this[_0x1da8f1(0x172)](),this[_0x1da8f1(0x1ae)][_0x1da8f1(0x1a6)]=0xa0;const _0x4ee4c1=ColorManager[_0x1da8f1(0x2ad)]();this[_0x1da8f1(0x1ae)][_0x1da8f1(0x1b8)](_0x16a742+0x1,_0x36fcda+0x1,_0x5babee-0x2,_0x51ef45-0x2,_0x4ee4c1),this['contents']['paintOpacity']=0xff;}}},ColorManager[_0x209d9c(0x2ad)]=function(){const _0x333b5a=_0x209d9c,_0x232993=VisuMZ[_0x333b5a(0x315)][_0x333b5a(0x20f)]['LevelUp'];let _0x2c9bd7=_0x232993[_0x333b5a(0x1ad)]!==undefined?_0x232993[_0x333b5a(0x1ad)]:0x13;return ColorManager[_0x333b5a(0x2e6)](_0x2c9bd7);},Window_VictoryLevelUpActor[_0x209d9c(0x298)][_0x209d9c(0x13b)]=function(){const _0x21f8c8=_0x209d9c,_0x2a35f7=this[_0x21f8c8(0x172)](),_0x5b506b='→',_0x97a167=this[_0x21f8c8(0x158)](),_0x18370b=_0x2a35f7*0x2,_0x1a6fd3=this['height']-_0x2a35f7*5.5,_0xd44d49=this[_0x21f8c8(0x21b)](_0x5b506b)+this[_0x21f8c8(0x17e)]()*0x2,_0x481a94=Window_VictoryLevelUpActor['_drawParamDiff']?0x4:0x3,_0xb8e138=Math[_0x21f8c8(0x297)]((this[_0x21f8c8(0x1a8)]/0x2-_0xd44d49-this[_0x21f8c8(0x17e)]()*0x2)/_0x481a94),_0x39054b=_0x1a6fd3-_0x18370b,_0x3cd3b4=VisuMZ['VictoryAftermath'][_0x21f8c8(0x20f)][_0x21f8c8(0x17b)][_0x21f8c8(0x30b)],_0x115545=SceneManager['_scene']['_victoryContinueWindow']['x']+this['itemPadding'](),_0x31bfac=_0x115545+_0xb8e138,_0x141b16=_0x31bfac+_0xb8e138,_0x44ce4c=_0x141b16+_0xd44d49,_0x285a2e=_0x44ce4c+_0xb8e138;let _0x362cb2=Math[_0x21f8c8(0x297)](_0x18370b+(_0x39054b-(_0x97a167['length']+(_0x3cd3b4?0x0:0x1))*_0x2a35f7)/0x2),_0x54590d=0x2;if(!_0x3cd3b4){if(_0x21f8c8(0x314)!==_0x21f8c8(0x1d6)){this['resetFontSettings']();if(VisuMZ[_0x21f8c8(0x2c9)]){if(_0x21f8c8(0x28f)===_0x21f8c8(0x2e5)){const _0x344b23=_0x822c47[_0x21f8c8(0x14d)][_0x21f8c8(0x20f)];if(_0x344b23[_0x21f8c8(0x250)][_0x21f8c8(0x231)])return _0x344b23[_0x21f8c8(0x250)][_0x21f8c8(0x179)][_0x21f8c8(0x1a7)](_0x23b232['earnedAbilityPoints'](),_0x15bd43[_0x21f8c8(0x307)],_0x1bf38c[_0x21f8c8(0x1ce)]);if(_0x344b23['SkillPoints'][_0x21f8c8(0x231)])return _0x344b23[_0x21f8c8(0x261)][_0x21f8c8(0x179)]['format'](_0x4401ec['earnedSkillPoints'](),_0x293215[_0x21f8c8(0x155)],_0x3df74e[_0x21f8c8(0x14e)]);}else this[_0x21f8c8(0x1ae)][_0x21f8c8(0x2dc)]=Window_EquipStatus[_0x21f8c8(0x298)][_0x21f8c8(0x2f5)]();}this[_0x21f8c8(0x259)](_0x115545,_0x362cb2,_0xb8e138,_0x2a35f7,_0x54590d),this[_0x21f8c8(0x149)](_0x21f8c8(0x1f0),_0x115545,_0x362cb2,_0xb8e138),this[_0x21f8c8(0x259)](_0x31bfac,_0x362cb2,_0xb8e138,_0x2a35f7,_0x54590d),this[_0x21f8c8(0x1f4)](_0x21f8c8(0x1f0),_0x31bfac,_0x362cb2,_0xb8e138),this[_0x21f8c8(0x259)](_0x141b16,_0x362cb2,_0xd44d49,_0x2a35f7,_0x54590d),this[_0x21f8c8(0x135)](ColorManager[_0x21f8c8(0x157)]()),this[_0x21f8c8(0x2d9)](_0x5b506b,_0x141b16,_0x362cb2,_0xd44d49,_0x21f8c8(0x248)),this['drawItemDarkRect'](_0x44ce4c,_0x362cb2,_0xb8e138,_0x2a35f7,_0x54590d),this['drawParamAfterValue']('level',_0x44ce4c,_0x362cb2,_0xb8e138);if(Window_VictoryLevelUpActor[_0x21f8c8(0x1ca)]){if(_0x21f8c8(0x2f1)!==_0x21f8c8(0x181))this[_0x21f8c8(0x259)](_0x285a2e,_0x362cb2,_0xb8e138,_0x2a35f7,_0x54590d),this[_0x21f8c8(0x206)](_0x21f8c8(0x1f0),_0x285a2e,_0x362cb2,_0xb8e138);else{const _0x2a73eb=this['lineHeight'](),_0x590e87=this[_0x21f8c8(0x2f8)]['width']-_0x2a73eb,_0x5e8c85=_0x3dc4fc[_0x21f8c8(0x298)][_0x21f8c8(0x246)](),_0x2d2007=_0x239598[_0x21f8c8(0x297)](_0x2a73eb/0x2),_0x58b006=_0x2a73eb*0x2-_0x5e8c85-0x2,_0x1940e7=_0x5d7058[_0x21f8c8(0x1e2)]((_0x590e87-0x2)*this['actor']()[_0x21f8c8(0x16e)]()),_0x18a95a=_0x5e8c85-0x2,_0x104106=this[_0x21f8c8(0x268)](),_0x3af18d=this[_0x21f8c8(0x1a1)](),_0x2975c1=this['gaugeColor2']();this[_0x21f8c8(0x2f8)]['fillRect'](_0x2d2007,_0x58b006,_0x590e87,_0x5e8c85,_0x104106),this['bitmap'][_0x21f8c8(0x20a)](_0x2d2007+0x1,_0x58b006+0x1,_0x1940e7,_0x18a95a,_0x3af18d,_0x2975c1);}}_0x362cb2+=_0x2a35f7,_0x54590d=_0x54590d===0x2?0x1:0x2;}else _0x4efa56[_0x21f8c8(0x2ee)]()['push'](_0x48e39b[_0x21f8c8(0x26d)]());}for(const _0x556bff of _0x97a167){this[_0x21f8c8(0x2d1)]();if(VisuMZ[_0x21f8c8(0x2c9)]){if('ZJDpP'!==_0x21f8c8(0x1eb)){const _0x439a5f=_0x4be1bf[_0x21f8c8(0x315)][_0x21f8c8(0x20f)][_0x21f8c8(0x313)],_0x4e4a71=_0x40fa87['_scene'];_0x2852a3(_0x4e4a71['finishVictoryPhase'][_0x21f8c8(0x1a9)](_0x4e4a71),_0x439a5f[_0x21f8c8(0x2fc)]);}else this[_0x21f8c8(0x1ae)][_0x21f8c8(0x2dc)]=Window_EquipStatus[_0x21f8c8(0x298)]['paramValueFontSize']();}this[_0x21f8c8(0x259)](_0x115545,_0x362cb2,_0xb8e138,_0x2a35f7,_0x54590d),this[_0x21f8c8(0x149)](_0x556bff,_0x115545,_0x362cb2,_0xb8e138),this['drawItemDarkRect'](_0x31bfac,_0x362cb2,_0xb8e138,_0x2a35f7,_0x54590d),this[_0x21f8c8(0x1f4)](_0x556bff,_0x31bfac,_0x362cb2,_0xb8e138),this[_0x21f8c8(0x259)](_0x141b16,_0x362cb2,_0xd44d49,_0x2a35f7,_0x54590d),this[_0x21f8c8(0x135)](ColorManager[_0x21f8c8(0x157)]()),this[_0x21f8c8(0x2d9)](_0x5b506b,_0x141b16,_0x362cb2,_0xd44d49,'center'),this['drawItemDarkRect'](_0x44ce4c,_0x362cb2,_0xb8e138,_0x2a35f7,_0x54590d),this['drawParamAfterValue'](_0x556bff,_0x44ce4c,_0x362cb2,_0xb8e138);if(Window_VictoryLevelUpActor[_0x21f8c8(0x1ca)]){if(_0x21f8c8(0x139)!==_0x21f8c8(0x139)){const _0x2bf8fa=_0xb82105[_0x21f8c8(0x167)][_0x21f8c8(0x20f)];if(_0x2bf8fa[_0x21f8c8(0x1bf)]['AftermathActorDisplay'])return _0x2bf8fa[_0x21f8c8(0x1bf)][_0x21f8c8(0x179)][_0x21f8c8(0x1a7)](_0x121b2a['earnedClassPoints'](),_0x508b04[_0x21f8c8(0x2b6)],_0x83fc99[_0x21f8c8(0x27e)]);if(_0x2bf8fa['JobPoints'][_0x21f8c8(0x231)])return _0x2bf8fa[_0x21f8c8(0x1b6)][_0x21f8c8(0x179)][_0x21f8c8(0x1a7)](_0x28220c[_0x21f8c8(0x182)](),_0xaa0843[_0x21f8c8(0x28e)],_0x57eda6[_0x21f8c8(0x1ff)]);}else this['drawItemDarkRect'](_0x285a2e,_0x362cb2,_0xb8e138,_0x2a35f7,_0x54590d),this['drawParamDiffValue'](_0x556bff,_0x285a2e,_0x362cb2,_0xb8e138);}_0x362cb2+=_0x2a35f7,_0x54590d=_0x54590d===0x2?0x1:0x2;}},Window_VictoryLevelUpActor[_0x209d9c(0x298)]['actorParams']=function(){const _0xbcc523=_0x209d9c;if(Imported[_0xbcc523(0x2ec)]){if(_0xbcc523(0x234)===_0xbcc523(0x1e6))this[_0xbcc523(0x138)](),this[_0xbcc523(0x12f)](),this[_0xbcc523(0x25c)](),this[_0xbcc523(0x196)]();else return VisuMZ[_0xbcc523(0x1f2)]['Settings'][_0xbcc523(0x2e1)][_0xbcc523(0x27c)];}else return[0x0,0x1,0x2,0x3,0x4,0x5,0x6,0x7];},Window_VictoryLevelUpActor[_0x209d9c(0x298)][_0x209d9c(0x149)]=function(_0x17c29d,_0x369869,_0x540395,_0x4fec30){const _0x179604=_0x209d9c;this['changeTextColor'](ColorManager[_0x179604(0x157)]());let _0x252c06='';_0x17c29d==='level'?_0x179604(0x273)===_0x179604(0x273)?_0x252c06=TextManager['level']:this[_0x179604(0x2b7)][_0x179604(0x136)]=this[_0x179604(0x137)]:_0x252c06=TextManager[_0x179604(0x1ab)](_0x17c29d),this[_0x179604(0x2d9)](_0x252c06,_0x369869+this['itemPadding'](),_0x540395,_0x4fec30-this[_0x179604(0x17e)]()*0x2);},Window_VictoryLevelUpActor[_0x209d9c(0x298)][_0x209d9c(0x1f4)]=function(_0x362533,_0x41a567,_0x232ae5,_0x92f64e){const _0x5c8f34=_0x209d9c,_0x58b779=this[_0x5c8f34(0x190)]();let _0x563b8a='';if(_0x362533==='level'){if(_0x5c8f34(0x2a4)==='BhAsV')_0x563b8a=_0x58b779[_0x5c8f34(0x1f0)];else return!![];}else _0x563b8a=Imported[_0x5c8f34(0x2ec)]?_0x58b779[_0x5c8f34(0x1b9)](_0x362533,!![]):_0x58b779[_0x5c8f34(0x1ab)](_0x362533);this['changeTextColor'](ColorManager[_0x5c8f34(0x2c4)]()),this[_0x5c8f34(0x2d9)](_0x563b8a,_0x41a567+this[_0x5c8f34(0x17e)](),_0x232ae5,_0x92f64e-this[_0x5c8f34(0x17e)]()*0x2,_0x5c8f34(0x1ec));},Window_VictoryLevelUpActor['prototype'][_0x209d9c(0x1c0)]=function(_0x17fcfc,_0x47e0a4,_0x1b93f3,_0x23ea83){const _0x514f1d=_0x209d9c,_0x3c4d4a=this['beforeActor'](),_0x3bc0f5=this['_actor'];let _0x1f68c7=0x0,_0x43ce0f=0x0,_0x3b3d82='0';_0x17fcfc===_0x514f1d(0x1f0)?_0x514f1d(0x30d)===_0x514f1d(0x130)?_0x1cf07c=_0x54045a[_0x514f1d(0x2ec)]?_0x102e29['paramValueByName'](_0x33234d,!![]):_0x480a7c[_0x514f1d(0x1ab)](_0x585533):(_0x1f68c7=_0x3c4d4a[_0x514f1d(0x1f0)],_0x43ce0f=_0x3bc0f5[_0x514f1d(0x1f0)],_0x3b3d82=_0x43ce0f-_0x1f68c7):(_0x1f68c7=Imported[_0x514f1d(0x2ec)]?_0x3c4d4a[_0x514f1d(0x1b9)](_0x17fcfc,![]):_0x3c4d4a[_0x514f1d(0x1ab)](_0x17fcfc),_0x43ce0f=Imported['VisuMZ_0_CoreEngine']?_0x3bc0f5[_0x514f1d(0x1b9)](_0x17fcfc,![]):_0x3bc0f5[_0x514f1d(0x1ab)](_0x17fcfc),_0x3b3d82=Imported[_0x514f1d(0x2ec)]?_0x3bc0f5[_0x514f1d(0x1b9)](_0x17fcfc,!![]):_0x43ce0f);const _0x672d6f=_0x43ce0f-_0x1f68c7;this[_0x514f1d(0x135)](ColorManager['paramchangeTextColor'](_0x672d6f)),this[_0x514f1d(0x2d9)](_0x3b3d82,_0x47e0a4+this[_0x514f1d(0x17e)](),_0x1b93f3,_0x23ea83-this['itemPadding']()*0x2,'right');},Window_VictoryLevelUpActor[_0x209d9c(0x298)][_0x209d9c(0x206)]=function(_0x141d58,_0x5c125e,_0x9bec2b,_0x40fbdf){const _0x28f50a=_0x209d9c,_0x3d6395=this['beforeActor'](),_0x557dbd=this[_0x28f50a(0x199)];let _0xe7eb71=0x0,_0x4af68a=0x0;_0x141d58===_0x28f50a(0x1f0)?(_0xe7eb71=_0x3d6395[_0x28f50a(0x1f0)],_0x4af68a=_0x557dbd[_0x28f50a(0x1f0)]):(_0xe7eb71=Imported['VisuMZ_0_CoreEngine']?_0x3d6395['paramValueByName'](_0x141d58,![]):_0x3d6395[_0x28f50a(0x1ab)](_0x141d58),_0x4af68a=Imported['VisuMZ_0_CoreEngine']?_0x557dbd[_0x28f50a(0x1b9)](_0x141d58,![]):_0x557dbd[_0x28f50a(0x1ab)](_0x141d58));const _0x156626=_0x4af68a-_0xe7eb71;let _0x4f0d69=_0x156626;if(_0xe7eb71%0x1!==0x0)_0x4f0d69=Math[_0x28f50a(0x297)](_0x156626*0x64)+'%';_0x156626!==0x0&&(this[_0x28f50a(0x135)](ColorManager[_0x28f50a(0x2e9)](_0x156626)),_0x4f0d69=(_0x156626>=0x0?_0x28f50a(0x2de):_0x28f50a(0x223))['format'](_0x4f0d69),this[_0x28f50a(0x2d9)](_0x4f0d69,_0x5c125e+this[_0x28f50a(0x17e)](),_0x9bec2b,_0x40fbdf-this[_0x28f50a(0x17e)]()*0x2,'left'));},Window_VictoryLevelUpActor['prototype'][_0x209d9c(0x165)]=function(){const _0x647549=_0x209d9c;this['resetFontSettings']();const _0x430342=this[_0x647549(0x247)]();if(_0x430342['length']<=0x0)return;const _0x2fe8c1=VisuMZ[_0x647549(0x315)][_0x647549(0x20f)][_0x647549(0x17b)][_0x647549(0x162)];while(_0x430342['length']>_0x2fe8c1){_0x430342[_0x647549(0x2f3)]();}this[_0x647549(0x224)](_0x430342),this[_0x647549(0x2f2)](_0x430342);},Window_VictoryLevelUpActor['prototype'][_0x209d9c(0x247)]=function(){const _0xb50bf5=_0x209d9c,_0x1e9390=this[_0xb50bf5(0x190)]()[_0xb50bf5(0x185)]();return this['_actor'][_0xb50bf5(0x247)](_0x1e9390);},Window_VictoryLevelUpActor[_0x209d9c(0x298)]['drawNewLearnedSkillsBackground']=function(_0x2aa7c1){const _0x5d0c59=_0x209d9c,_0x11332a=this[_0x5d0c59(0x172)](),_0x2af209=_0x5d0c59(0x2a0),_0x30426e=_0x5d0c59(0x1bc),_0x43c669=ColorManager[_0x5d0c59(0x2c4)](),_0x47361a=Math[_0x5d0c59(0x297)](this[_0x5d0c59(0x1a8)]/0x2)-0x64-_0x11332a*0x2,_0x20f4d5=(_0x2aa7c1[_0x5d0c59(0x2c7)]+0x1)*_0x11332a,_0x8f4bdf=_0x11332a,_0x58e21f=this[_0x5d0c59(0x15b)]-_0x11332a*6.5-_0x20f4d5;this[_0x5d0c59(0x1ae)][_0x5d0c59(0x1b8)](_0x8f4bdf-0x2,_0x58e21f-0x2,_0x47361a+0x4,_0x20f4d5+0x4,_0x43c669),this[_0x5d0c59(0x1ae)][_0x5d0c59(0x173)](_0x8f4bdf,_0x58e21f,_0x47361a,_0x20f4d5),this[_0x5d0c59(0x1ae)][_0x5d0c59(0x20a)](_0x8f4bdf,_0x58e21f,_0x47361a,_0x20f4d5,_0x2af209,_0x30426e);},Window_VictoryLevelUpActor[_0x209d9c(0x298)][_0x209d9c(0x2f2)]=function(_0x1c5301){const _0x3d1985=_0x209d9c,_0x57710c=this['lineHeight'](),_0x13215f=_0x3d1985(0x2a0),_0x4e1380='rgba(0,\x200,\x200,\x200.4)',_0x5db8e7=ColorManager[_0x3d1985(0x2c4)](),_0x5349c0=Math[_0x3d1985(0x297)](this[_0x3d1985(0x1a8)]/0x2)-0x64-(_0x57710c+this[_0x3d1985(0x17e)]())*0x2,_0x57bcc2=(_0x1c5301[_0x3d1985(0x2c7)]+0x1)*_0x57710c;let _0x345164=_0x57710c+this[_0x3d1985(0x17e)](),_0x149f31=this[_0x3d1985(0x15b)]-_0x57710c*6.5-_0x57bcc2;const _0x142c99=TextManager['victoryNewSkillFmt'][_0x3d1985(0x1a7)](this['_actor'][_0x3d1985(0x241)]()),_0x38eb9c=this[_0x3d1985(0x1cd)](_0x142c99)[_0x3d1985(0x1a8)],_0x95838a=Math[_0x3d1985(0x297)](_0x345164+(_0x5349c0-_0x38eb9c)/0x2);this[_0x3d1985(0x277)](_0x142c99,_0x95838a,_0x149f31,_0x38eb9c),_0x149f31+=_0x57710c,this[_0x3d1985(0x1ae)]['fillRect'](_0x345164,_0x149f31-0x1,_0x5349c0,0x2,_0x5db8e7);for(const _0x10f8e0 of _0x1c5301){if(!_0x10f8e0)continue;this['resetFontSettings'](),this[_0x3d1985(0x230)](_0x10f8e0,_0x345164+this[_0x3d1985(0x17e)](),_0x149f31,_0x5349c0-this[_0x3d1985(0x17e)]()*0x2),_0x149f31+=_0x57710c;}},Window_VictoryLevelUpActor[_0x209d9c(0x298)][_0x209d9c(0x2aa)]=function(){const _0x2ba628=_0x209d9c,_0xdcaab7=this[_0x2ba628(0x172)](),_0x5d8fae=Window_VictoryLevelUpActor['_showFace'],_0x464a47=this['getQuoteWidth'](),_0x440cd8=_0xdcaab7*0x4,_0x547569=Math['round']((this[_0x2ba628(0x1a8)]-_0x464a47)/0x2),_0x1b3645=_0x547569+(_0x5d8fae?ImageManager[_0x2ba628(0x202)]+0x14:0x0),_0x5b3fa2=this[_0x2ba628(0x15b)]-_0xdcaab7*5.5;let _0x197caa=this[_0x2ba628(0x17a)]();_0x5d8fae&&this[_0x2ba628(0x265)](this[_0x2ba628(0x199)],_0x547569,_0x5b3fa2,ImageManager['faceWidth'],ImageManager['faceHeight']),this['drawTextEx'](_0x197caa,_0x1b3645,_0x5b3fa2,_0x464a47-_0x1b3645);},Window_VictoryLevelUpActor[_0x209d9c(0x298)][_0x209d9c(0x26c)]=function(){const _0x20bd8b=_0x209d9c;let _0x23df9d=Graphics[_0x20bd8b(0x2d4)];if(Imported[_0x20bd8b(0x13d)]){if(_0x20bd8b(0x26f)!==_0x20bd8b(0x26f)){const _0x16dfea=_0x4fbaf6['prototype']['lineHeight'](),_0x2d789e=_0x41d908['round'](_0x5274f4[_0x20bd8b(0x1a8)]/0x2)-0x64,_0x4a2ec6=_0x32d374[_0x20bd8b(0x297)](_0x332bea[_0x20bd8b(0x15b)]-_0x16dfea*1.25),_0x152f08=_0x1db023[_0x20bd8b(0x297)](_0x385418['width']/0x2),_0x400ef7=_0x16dfea;return new _0x56dc10(_0x2d789e,_0x4a2ec6,_0x152f08,_0x400ef7);}else _0x23df9d=Math[_0x20bd8b(0x2cb)](_0x23df9d,VisuMZ[_0x20bd8b(0x24d)][_0x20bd8b(0x20f)][_0x20bd8b(0x313)][_0x20bd8b(0x2e3)]);}return _0x23df9d-this[_0x20bd8b(0x17e)]()*0x2;},Window_VictoryLevelUpActor[_0x209d9c(0x298)][_0x209d9c(0x17a)]=function(){const _0x35d72c=_0x209d9c;return this[_0x35d72c(0x247)]()['length']>0x0?TextManager[_0x35d72c(0x264)](this[_0x35d72c(0x199)])[_0x35d72c(0x1a7)](this[_0x35d72c(0x199)][_0x35d72c(0x241)]()):TextManager[_0x35d72c(0x2d2)](this[_0x35d72c(0x199)])[_0x35d72c(0x1a7)](this[_0x35d72c(0x199)][_0x35d72c(0x241)]());};